var search_data = {"index":{"searchIndex":["kernel","pathname","+()","/()","<=>()","==()","===()","pathname()","absolute?()","ascend()","atime()","basename()","binread()","binwrite()","birthtime()","blockdev?()","chardev?()","children()","chmod()","chown()","cleanpath()","ctime()","delete()","descend()","directory?()","dirname()","each_child()","each_entry()","each_filename()","each_line()","empty?()","entries()","eql?()","executable?()","executable_real?()","exist?()","expand_path()","extname()","file?()","find()","fnmatch()","fnmatch?()","freeze()","ftype()","getwd()","glob()","glob()","grpowned?()","join()","lchmod()","lchown()","lstat()","lutime()","make_link()","make_symlink()","mkdir()","mkpath()","mountpoint?()","mtime()","new()","open()","opendir()","owned?()","parent()","pipe?()","pwd()","read()","readable?()","readable_real?()","readlines()","readlink()","realdirpath()","realpath()","relative?()","relative_path_from()","rename()","rmdir()","rmtree()","root?()","setgid?()","setuid?()","size()","size?()","socket?()","split()","stat()","sticky?()","sub()","sub_ext()","symlink?()","sysopen()","taint()","to_path()","to_s()","truncate()","unlink()","untaint()","utime()","world_readable?()","world_writable?()","writable?()","writable_real?()","write()","zero?()"],"longSearchIndex":["kernel","pathname","pathname#+()","pathname#/()","pathname#<=>()","pathname#==()","pathname#===()","kernel#pathname()","pathname#absolute?()","pathname#ascend()","pathname#atime()","pathname#basename()","pathname#binread()","pathname#binwrite()","pathname#birthtime()","pathname#blockdev?()","pathname#chardev?()","pathname#children()","pathname#chmod()","pathname#chown()","pathname#cleanpath()","pathname#ctime()","pathname#delete()","pathname#descend()","pathname#directory?()","pathname#dirname()","pathname#each_child()","pathname#each_entry()","pathname#each_filename()","pathname#each_line()","pathname#empty?()","pathname#entries()","pathname#eql?()","pathname#executable?()","pathname#executable_real?()","pathname#exist?()","pathname#expand_path()","pathname#extname()","pathname#file?()","pathname#find()","pathname#fnmatch()","pathname#fnmatch?()","pathname#freeze()","pathname#ftype()","pathname::getwd()","pathname::glob()","pathname#glob()","pathname#grpowned?()","pathname#join()","pathname#lchmod()","pathname#lchown()","pathname#lstat()","pathname#lutime()","pathname#make_link()","pathname#make_symlink()","pathname#mkdir()","pathname#mkpath()","pathname#mountpoint?()","pathname#mtime()","pathname::new()","pathname#open()","pathname#opendir()","pathname#owned?()","pathname#parent()","pathname#pipe?()","pathname::pwd()","pathname#read()","pathname#readable?()","pathname#readable_real?()","pathname#readlines()","pathname#readlink()","pathname#realdirpath()","pathname#realpath()","pathname#relative?()","pathname#relative_path_from()","pathname#rename()","pathname#rmdir()","pathname#rmtree()","pathname#root?()","pathname#setgid?()","pathname#setuid?()","pathname#size()","pathname#size?()","pathname#socket?()","pathname#split()","pathname#stat()","pathname#sticky?()","pathname#sub()","pathname#sub_ext()","pathname#symlink?()","pathname#sysopen()","pathname#taint()","pathname#to_path()","pathname#to_s()","pathname#truncate()","pathname#unlink()","pathname#untaint()","pathname#utime()","pathname#world_readable?()","pathname#world_writable?()","pathname#writable?()","pathname#writable_real?()","pathname#write()","pathname#zero?()"],"info":[["Kernel","","Kernel.html","",""],["Pathname","","Pathname.html","","<p>Pathname represents the name of a file or directory on the filesystem, but not the file itself.\n<p>The pathname …\n"],["+","Pathname","Pathname.html#method-i-2B","(other)","<p>Appends a pathname fragment to <code>self</code> to produce a new Pathname object. Since <code>other</code> is considered as a …\n"],["/","Pathname","Pathname.html#method-i-2F","(other)",""],["<=>","Pathname","Pathname.html#method-i-3C-3D-3E","(p1)","<p>Provides a case-sensitive comparison operator for pathnames.\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">Pathname</span>.<span class=\"ruby-identifier\">new</span>(<span class=\"ruby-string\">&#39;/usr&#39;</span>) <span class=\"ruby-operator\">&lt;=&gt;</span> <span class=\"ruby-constant\">Pathname</span>.<span class=\"ruby-identifier\">new</span>(<span class=\"ruby-string\">&#39;/usr/bin&#39;</span>) <span class=\"ruby-operator\">...</span>\n</pre>\n"],["==","Pathname","Pathname.html#method-i-3D-3D","(p1)","<p>Compare this pathname with <code>other</code>.  The comparison is string-based. Be aware that two different paths …\n"],["===","Pathname","Pathname.html#method-i-3D-3D-3D","(p1)","<p>Compare this pathname with <code>other</code>.  The comparison is string-based. Be aware that two different paths …\n"],["Pathname","Kernel","Kernel.html#method-i-Pathname","(p1)","<p>Creates a new Pathname object from the given string, <code>path</code>, and returns pathname object.\n<p>In order to use …\n"],["absolute?","Pathname","Pathname.html#method-i-absolute-3F","()","<p>Predicate method for testing whether a path is absolute.\n<p>It returns <code>true</code> if the pathname begins with a …\n"],["ascend","Pathname","Pathname.html#method-i-ascend","()","<p>Iterates over and yields a new Pathname object for each element in the given path in ascending order. …\n"],["atime","Pathname","Pathname.html#method-i-atime","()","<p>Returns the last access time for the file.\n<p>See File.atime.\n"],["basename","Pathname","Pathname.html#method-i-basename","(p1 = v1)","<p>Returns the last component of the path.\n<p>See File.basename.\n"],["binread","Pathname","Pathname.html#method-i-binread","(p1 = v1, p2 = v2)","<p>Returns all the bytes from the file, or the first <code>N</code> if specified.\n<p>See File.binread.\n"],["binwrite","Pathname","Pathname.html#method-i-binwrite","(p1 = v1, p2 = v2, p3 = v3)","<p>Writes <code>contents</code> to the file, opening it in binary mode.\n<p>See File.binwrite.\n"],["birthtime","Pathname","Pathname.html#method-i-birthtime","()","<p>Returns the birth time for the file. If the platform doesn’t have birthtime, raises NotImplementedError …\n"],["blockdev?","Pathname","Pathname.html#method-i-blockdev-3F","()","<p>See FileTest.blockdev?.\n"],["chardev?","Pathname","Pathname.html#method-i-chardev-3F","()","<p>See FileTest.chardev?.\n"],["children","Pathname","Pathname.html#method-i-children","(with_directory=true)","<p>Returns the children of the directory (files and subdirectories, not recursive) as an array of Pathname …\n"],["chmod","Pathname","Pathname.html#method-i-chmod","(p1)","<p>Changes file permissions.\n<p>See File.chmod.\n"],["chown","Pathname","Pathname.html#method-i-chown","(p1, p2)","<p>Change owner and group of the file.\n<p>See File.chown.\n"],["cleanpath","Pathname","Pathname.html#method-i-cleanpath","(consider_symlink=false)","<p>Returns clean pathname of <code>self</code> with consecutive slashes and useless dots removed.  The filesystem is …\n"],["ctime","Pathname","Pathname.html#method-i-ctime","()","<p>Returns the last change time, using directory information, not the file itself.\n<p>See File.ctime.\n"],["delete","Pathname","Pathname.html#method-i-delete","()","<p>Removes a file or directory, using File.unlink if <code>self</code> is a file, or Dir.unlink as necessary.\n"],["descend","Pathname","Pathname.html#method-i-descend","()","<p>Iterates over and yields a new Pathname object for each element in the given path in descending order. …\n"],["directory?","Pathname","Pathname.html#method-i-directory-3F","()","<p>See FileTest.directory?.\n"],["dirname","Pathname","Pathname.html#method-i-dirname","()","<p>Returns all but the last component of the path.\n<p>See File.dirname.\n"],["each_child","Pathname","Pathname.html#method-i-each_child","(with_directory=true, &b)","<p>Iterates over the children of the directory (files and subdirectories, not recursive).\n<p>It yields Pathname …\n"],["each_entry","Pathname","Pathname.html#method-i-each_entry","()","<p>Iterates over the entries (files and subdirectories) in the directory, yielding a Pathname object for …\n"],["each_filename","Pathname","Pathname.html#method-i-each_filename","()","<p>Iterates over each component of the path.\n\n<pre>Pathname.new(&quot;/usr/bin/ruby&quot;).each_filename {|filename| ... ...</pre>\n"],["each_line","Pathname","Pathname.html#method-i-each_line","(p1 = v1, p2 = v2, p3 = v3)","<p>Iterates over each line in the file and yields a String object for each.\n"],["empty?","Pathname","Pathname.html#method-i-empty-3F","()","<p>Tests the file is empty.\n<p>See Dir#empty? and FileTest.empty?.\n"],["entries","Pathname","Pathname.html#method-i-entries","()","<p>Return the entries (files and subdirectories) in the directory, each as a Pathname object.\n<p>The results …\n"],["eql?","Pathname","Pathname.html#method-i-eql-3F","(p1)","<p>Compare this pathname with <code>other</code>.  The comparison is string-based. Be aware that two different paths …\n"],["executable?","Pathname","Pathname.html#method-i-executable-3F","()","<p>See FileTest.executable?.\n"],["executable_real?","Pathname","Pathname.html#method-i-executable_real-3F","()","<p>See FileTest.executable_real?.\n"],["exist?","Pathname","Pathname.html#method-i-exist-3F","()","<p>See FileTest.exist?.\n"],["expand_path","Pathname","Pathname.html#method-i-expand_path","(p1 = v1)","<p>Returns the absolute path for the file.\n<p>See File.expand_path.\n"],["extname","Pathname","Pathname.html#method-i-extname","()","<p>Returns the file’s extension.\n<p>See File.extname.\n"],["file?","Pathname","Pathname.html#method-i-file-3F","()","<p>See FileTest.file?.\n"],["find","Pathname","Pathname.html#method-i-find","(ignore_error: true)","<p>Iterates over the directory tree in a depth first manner, yielding a Pathname for each file under “this” …\n"],["fnmatch","Pathname","Pathname.html#method-i-fnmatch","(p1, p2 = v2)","<p>Return <code>true</code> if the receiver matches the given pattern.\n<p>See File.fnmatch.\n"],["fnmatch?","Pathname","Pathname.html#method-i-fnmatch-3F","(p1, p2 = v2)","<p>Return <code>true</code> if the receiver matches the given pattern.\n<p>See File.fnmatch.\n"],["freeze","Pathname","Pathname.html#method-i-freeze","()","<p>Freezes this Pathname.\n<p>See Object.freeze.\n"],["ftype","Pathname","Pathname.html#method-i-ftype","()","<p>Returns “type” of file (“file”, “directory”, etc).\n<p>See File.ftype.\n"],["getwd","Pathname","Pathname.html#method-c-getwd","()","<p>Returns the current working directory as a Pathname.\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">Pathname</span>.<span class=\"ruby-identifier\">getwd</span>\n    <span class=\"ruby-comment\">#=&gt; #&lt;Pathname:/home/zzak/projects/ruby&gt;</span>\n</pre>\n"],["glob","Pathname","Pathname.html#method-c-glob","(p1, p2 = v2, p3 = v3)","<p>Returns or yields Pathname objects.\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">Pathname</span>.<span class=\"ruby-identifier\">glob</span>(<span class=\"ruby-string\">&quot;lib/i*.rb&quot;</span>)\n    <span class=\"ruby-comment\">#=&gt; [#&lt;Pathname:lib/ipaddr.rb&gt;, #&lt;Pathname:lib/irb.rb&gt;]</span>\n</pre>\n"],["glob","Pathname","Pathname.html#method-i-glob","(p1, p2 = v2)","<p>Returns or yields Pathname objects.\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">Pathname</span>(<span class=\"ruby-string\">&quot;ruby-2.4.2&quot;</span>).<span class=\"ruby-identifier\">glob</span>(<span class=\"ruby-string\">&quot;R*.md&quot;</span>)\n<span class=\"ruby-comment\">#=&gt; [#&lt;Pathname:ruby-2.4.2/README.md&gt;, ...</span>\n</pre>\n"],["grpowned?","Pathname","Pathname.html#method-i-grpowned-3F","()","<p>See FileTest.grpowned?.\n"],["join","Pathname","Pathname.html#method-i-join","(*args)","<p>Joins the given pathnames onto <code>self</code> to create a new Pathname object. This is effectively the same as …\n"],["lchmod","Pathname","Pathname.html#method-i-lchmod","(p1)","<p>Same as Pathname.chmod, but does not follow symbolic links.\n<p>See File.lchmod.\n"],["lchown","Pathname","Pathname.html#method-i-lchown","(p1, p2)","<p>Same as Pathname.chown, but does not follow symbolic links.\n<p>See File.lchown.\n"],["lstat","Pathname","Pathname.html#method-i-lstat","()","<p>See File.lstat.\n"],["lutime","Pathname","Pathname.html#method-i-lutime","(p1, p2)","<p>Update the access and modification times of the file.\n<p>Same as Pathname#utime, but does not follow symbolic …\n"],["make_link","Pathname","Pathname.html#method-i-make_link","(p1)","<p>Creates a hard link at <em>pathname</em>.\n<p>See File.link.\n"],["make_symlink","Pathname","Pathname.html#method-i-make_symlink","(p1)","<p>Creates a symbolic link.\n<p>See File.symlink.\n"],["mkdir","Pathname","Pathname.html#method-i-mkdir","(p1 = v1)","<p>Create the referenced directory.\n<p>See Dir.mkdir.\n"],["mkpath","Pathname","Pathname.html#method-i-mkpath","(mode: nil)","<p>Creates a full path, including any intermediate directories that don’t yet exist.\n<p>See FileUtils.mkpath …\n"],["mountpoint?","Pathname","Pathname.html#method-i-mountpoint-3F","()","<p>Returns <code>true</code> if <code>self</code> points to a mountpoint.\n"],["mtime","Pathname","Pathname.html#method-i-mtime","()","<p>Returns the last modified time of the file.\n<p>See File.mtime.\n"],["new","Pathname","Pathname.html#method-c-new","(p1)","<p>Create a Pathname object from the given String (or String-like object). If <code>path</code> contains a NULL character …\n"],["open","Pathname","Pathname.html#method-i-open","(p1 = v1, p2 = v2, p3 = v3)","<p>Opens the file for reading or writing.\n<p>See File.open.\n"],["opendir","Pathname","Pathname.html#method-i-opendir","()","<p>Opens the referenced directory.\n<p>See Dir.open.\n"],["owned?","Pathname","Pathname.html#method-i-owned-3F","()","<p>See FileTest.owned?.\n"],["parent","Pathname","Pathname.html#method-i-parent","()","<p>Returns the parent directory.\n<p>This is same as <code>self + &#39;..&#39;</code>.\n"],["pipe?","Pathname","Pathname.html#method-i-pipe-3F","()","<p>See FileTest.pipe?.\n"],["pwd","Pathname","Pathname.html#method-c-pwd","()","<p>Returns the current working directory as a Pathname.\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">Pathname</span>.<span class=\"ruby-identifier\">getwd</span>\n    <span class=\"ruby-comment\">#=&gt; #&lt;Pathname:/home/zzak/projects/ruby&gt;</span>\n</pre>\n"],["read","Pathname","Pathname.html#method-i-read","(p1 = v1, p2 = v2, p3 = v3)","<p>Returns all data from the file, or the first <code>N</code> bytes if specified.\n<p>See File.read.\n"],["readable?","Pathname","Pathname.html#method-i-readable-3F","()","<p>See FileTest.readable?.\n"],["readable_real?","Pathname","Pathname.html#method-i-readable_real-3F","()","<p>See FileTest.readable_real?.\n"],["readlines","Pathname","Pathname.html#method-i-readlines","(p1 = v1, p2 = v2, p3 = v3)","<p>Returns all the lines from the file.\n<p>See File.readlines.\n"],["readlink","Pathname","Pathname.html#method-i-readlink","()","<p>Read symbolic link.\n<p>See File.readlink.\n"],["realdirpath","Pathname","Pathname.html#method-i-realdirpath","(p1 = v1)","<p>Returns the real (absolute) pathname of <code>self</code> in the actual filesystem.\n<p>Does not contain symlinks or useless …\n"],["realpath","Pathname","Pathname.html#method-i-realpath","(p1 = v1)","<p>Returns the real (absolute) pathname for <code>self</code> in the actual filesystem.\n<p>Does not contain symlinks or useless …\n"],["relative?","Pathname","Pathname.html#method-i-relative-3F","()","<p>The opposite of Pathname#absolute?\n<p>It returns <code>false</code> if the pathname begins with a slash.\n\n<pre class=\"ruby\"><span class=\"ruby-identifier\">p</span> = <span class=\"ruby-constant\">Pathname</span>.<span class=\"ruby-identifier\">new</span>(<span class=\"ruby-string\">&#39;/im/sure&#39;</span>) <span class=\"ruby-operator\">...</span>\n</pre>\n"],["relative_path_from","Pathname","Pathname.html#method-i-relative_path_from","(base_directory)","<p>Returns a relative path from the given <code>base_directory</code> to the receiver.\n<p>If <code>self</code> is absolute, then <code>base_directory</code> …\n"],["rename","Pathname","Pathname.html#method-i-rename","(p1)","<p>Rename the file.\n<p>See File.rename.\n"],["rmdir","Pathname","Pathname.html#method-i-rmdir","()","<p>Remove the referenced directory.\n<p>See Dir.rmdir.\n"],["rmtree","Pathname","Pathname.html#method-i-rmtree","(noop: nil, verbose: nil, secure: nil)","<p>Recursively deletes a directory, including all directories beneath it.\n<p>See FileUtils.rm_rf\n"],["root?","Pathname","Pathname.html#method-i-root-3F","()","<p>Predicate method for root directories.  Returns <code>true</code> if the pathname consists of consecutive slashes. …\n"],["setgid?","Pathname","Pathname.html#method-i-setgid-3F","()","<p>See FileTest.setgid?.\n"],["setuid?","Pathname","Pathname.html#method-i-setuid-3F","()","<p>See FileTest.setuid?.\n"],["size","Pathname","Pathname.html#method-i-size","()","<p>See FileTest.size.\n"],["size?","Pathname","Pathname.html#method-i-size-3F","()","<p>See FileTest.size?.\n"],["socket?","Pathname","Pathname.html#method-i-socket-3F","()","<p>See FileTest.socket?.\n"],["split","Pathname","Pathname.html#method-i-split","()","<p>Returns the #dirname and the #basename in an Array.\n<p>See File.split.\n"],["stat","Pathname","Pathname.html#method-i-stat","()","<p>Returns a File::Stat object.\n<p>See File.stat.\n"],["sticky?","Pathname","Pathname.html#method-i-sticky-3F","()","<p>See FileTest.sticky?.\n"],["sub","Pathname","Pathname.html#method-i-sub","(*args)","<p>Return a pathname which is substituted by String#sub.\n\n<pre>path1 = Pathname.new(&#39;/usr/bin/perl&#39;)\npath1.sub(&#39;perl&#39;, ...</pre>\n"],["sub_ext","Pathname","Pathname.html#method-i-sub_ext","(p1)","<p>Return a pathname with <code>repl</code> added as a suffix to the basename.\n<p>If self has no extension part, <code>repl</code> is …\n"],["symlink?","Pathname","Pathname.html#method-i-symlink-3F","()","<p>See FileTest.symlink?.\n"],["sysopen","Pathname","Pathname.html#method-i-sysopen","(p1 = v1, p2 = v2)","<p>See IO.sysopen.\n"],["taint","Pathname","Pathname.html#method-i-taint","()","<p>Returns pathname.  This method is deprecated and will be removed in Ruby 3.2.\n"],["to_path","Pathname","Pathname.html#method-i-to_path","()","<p>Return the path as a String.\n<p>to_path is implemented so Pathname objects are usable with File.open, etc. …\n"],["to_s","Pathname","Pathname.html#method-i-to_s","()","<p>Return the path as a String.\n<p>to_path is implemented so Pathname objects are usable with File.open, etc. …\n"],["truncate","Pathname","Pathname.html#method-i-truncate","(p1)","<p>Truncates the file to <code>length</code> bytes.\n<p>See File.truncate.\n"],["unlink","Pathname","Pathname.html#method-i-unlink","()","<p>Removes a file or directory, using File.unlink if <code>self</code> is a file, or Dir.unlink as necessary.\n"],["untaint","Pathname","Pathname.html#method-i-untaint","()","<p>Returns pathname.  This method is deprecated and will be removed in Ruby 3.2.\n"],["utime","Pathname","Pathname.html#method-i-utime","(p1, p2)","<p>Update the access and modification times of the file.\n<p>See File.utime.\n"],["world_readable?","Pathname","Pathname.html#method-i-world_readable-3F","()","<p>See FileTest.world_readable?.\n"],["world_writable?","Pathname","Pathname.html#method-i-world_writable-3F","()","<p>See FileTest.world_writable?.\n"],["writable?","Pathname","Pathname.html#method-i-writable-3F","()","<p>See FileTest.writable?.\n"],["writable_real?","Pathname","Pathname.html#method-i-writable_real-3F","()","<p>See FileTest.writable_real?.\n"],["write","Pathname","Pathname.html#method-i-write","(p1 = v1, p2 = v2, p3 = v3)","<p>Writes <code>contents</code> to the file.\n<p>See File.write.\n"],["zero?","Pathname","Pathname.html#method-i-zero-3F","()","<p>See FileTest.zero?.\n"]]}}