var search_data = {"index":{"searchIndex":["date","error","datetime","time","+()","-()","<<()","<=>()","===()",">>()","_httpdate()","_iso8601()","_jisx0301()","_parse()","_rfc2822()","_rfc3339()","_rfc822()","_strptime()","_strptime()","_xmlschema()","ajd()","amjd()","asctime()","civil()","civil()","commercial()","commercial()","ctime()","cwday()","cweek()","cwyear()","day()","day_fraction()","deconstruct_keys()","deconstruct_keys()","downto()","england()","friday?()","gregorian()","gregorian?()","gregorian_leap?()","hour()","httpdate()","httpdate()","httpdate()","infinite?()","inspect()","iso8601()","iso8601()","iso8601()","iso8601()","italy()","jd()","jd()","jd()","jisx0301()","jisx0301()","jisx0301()","jisx0301()","julian()","julian?()","julian_leap?()","ld()","leap?()","leap?()","mday()","min()","minute()","mjd()","mon()","monday?()","month()","new()","new()","new_offset()","new_start()","next()","next_day()","next_month()","next_year()","now()","offset()","ordinal()","ordinal()","parse()","parse()","prev_day()","prev_month()","prev_year()","rfc2822()","rfc2822()","rfc2822()","rfc3339()","rfc3339()","rfc3339()","rfc3339()","rfc822()","rfc822()","rfc822()","saturday?()","sec()","sec_fraction()","second()","second_fraction()","start()","step()","strftime()","strftime()","strptime()","strptime()","succ()","sunday?()","thursday?()","to_date()","to_date()","to_date()","to_datetime()","to_datetime()","to_datetime()","to_s()","to_s()","to_time()","to_time()","to_time()","today()","tuesday?()","upto()","valid_civil?()","valid_commercial?()","valid_date?()","valid_jd?()","valid_ordinal?()","wday()","wednesday?()","xmlschema()","xmlschema()","xmlschema()","xmlschema()","yday()","year()","zone()"],"longSearchIndex":["date","date::error","datetime","time","date#+()","date#-()","date#<<()","date#<=>()","date#===()","date#>>()","date::_httpdate()","date::_iso8601()","date::_jisx0301()","date::_parse()","date::_rfc2822()","date::_rfc3339()","date::_rfc822()","date::_strptime()","datetime::_strptime()","date::_xmlschema()","date#ajd()","date#amjd()","date#asctime()","date::civil()","datetime::civil()","date::commercial()","datetime::commercial()","date#ctime()","date#cwday()","date#cweek()","date#cwyear()","date#day()","date#day_fraction()","date#deconstruct_keys()","datetime#deconstruct_keys()","date#downto()","date#england()","date#friday?()","date#gregorian()","date#gregorian?()","date::gregorian_leap?()","datetime#hour()","date::httpdate()","date#httpdate()","datetime::httpdate()","date#infinite?()","date#inspect()","date::iso8601()","date#iso8601()","datetime::iso8601()","datetime#iso8601()","date#italy()","date::jd()","date#jd()","datetime::jd()","date::jisx0301()","date#jisx0301()","datetime::jisx0301()","datetime#jisx0301()","date#julian()","date#julian?()","date::julian_leap?()","date#ld()","date::leap?()","date#leap?()","date#mday()","datetime#min()","datetime#minute()","date#mjd()","date#mon()","date#monday?()","date#month()","date::new()","datetime::new()","datetime#new_offset()","date#new_start()","date#next()","date#next_day()","date#next_month()","date#next_year()","datetime::now()","datetime#offset()","date::ordinal()","datetime::ordinal()","date::parse()","datetime::parse()","date#prev_day()","date#prev_month()","date#prev_year()","date::rfc2822()","date#rfc2822()","datetime::rfc2822()","date::rfc3339()","date#rfc3339()","datetime::rfc3339()","datetime#rfc3339()","date::rfc822()","date#rfc822()","datetime::rfc822()","date#saturday?()","datetime#sec()","datetime#sec_fraction()","datetime#second()","datetime#second_fraction()","date#start()","date#step()","date#strftime()","datetime#strftime()","date::strptime()","datetime::strptime()","date#succ()","date#sunday?()","date#thursday?()","date#to_date()","datetime#to_date()","time#to_date()","date#to_datetime()","datetime#to_datetime()","time#to_datetime()","date#to_s()","datetime#to_s()","date#to_time()","datetime#to_time()","time#to_time()","date::today()","date#tuesday?()","date#upto()","date::valid_civil?()","date::valid_commercial?()","date::valid_date?()","date::valid_jd?()","date::valid_ordinal?()","date#wday()","date#wednesday?()","date::xmlschema()","date#xmlschema()","datetime::xmlschema()","datetime#xmlschema()","date#yday()","date#year()","datetime#zone()"],"info":[["Date","","Date.html","","<p>Class Date provides methods for storing and manipulating calendar dates.\n<p>Consider using class Time instead …\n"],["Date::Error","","Date/Error.html","","<p>Exception for invalid date/time\n"],["DateTime","","DateTime.html","","<p>DateTime\n<p>A subclass of Date that easily handles date, hour, minute, second, and offset.\n<p>DateTime class …\n"],["Time","","Time.html","",""],["+","Date","Date.html#method-i-2B","(p1)","<p>Returns a date object pointing <code>other</code> days after self.  The other should be a numeric value.  If the other …\n"],["-","Date","Date.html#method-i-2D","(p1)","<p>Returns the difference between the two dates if the other is a date object.  If the other is a numeric …\n"],["<<","Date","Date.html#method-i-3C-3C","(p1)","<p>Returns a new Date object representing the date <code>n</code> months earlier; <code>n</code> should be a numeric:\n\n<pre>(Date.new(2001, ...</pre>\n"],["<=>","Date","Date.html#method-i-3C-3D-3E","(p1)","<p>Compares <code>self</code> and <code>other</code>, returning:\n<p><code>-1</code> if <code>other</code> is larger.\n<p><code>0</code> if the two are equal.\n"],["===","Date","Date.html#method-i-3D-3D-3D","(p1)","<p>Returns <code>true</code> if <code>self</code> and <code>other</code> represent the same date, <code>false</code> if not, <code>nil</code> if the two are not comparable. …\n"],[">>","Date","Date.html#method-i-3E-3E","(p1)","<p>Returns a new Date object representing the date <code>n</code> months later; <code>n</code> should be a numeric:\n\n<pre>(Date.new(2001, ...</pre>\n"],["_httpdate","Date","Date.html#method-c-_httpdate","(p1, p2 = {})","<p>Returns a hash of values parsed from <code>string</code>, which should be a valid HTTP date format:\n\n<pre>d = Date.new(2001, ...</pre>\n"],["_iso8601","Date","Date.html#method-c-_iso8601","(p1, p2 = {})","<p>Returns a hash of values parsed from <code>string</code>, which should contain an ISO 8601 formatted date:\n\n<pre>d = Date.new(2001, ...</pre>\n"],["_jisx0301","Date","Date.html#method-c-_jisx0301","(p1, p2 = {})","<p>Returns a hash of values parsed from <code>string</code>, which should be a valid JIS X 0301 date format:\n\n<pre>d = Date.new(2001, ...</pre>\n"],["_parse","Date","Date.html#method-c-_parse","(*args)","<p><strong>Note</strong>: This method recognizes many forms in <code>string</code>, but it is not a validator. For formats, see “Specialized …\n"],["_rfc2822","Date","Date.html#method-c-_rfc2822","(p1, p2 = {})","<p>Returns a hash of values parsed from <code>string</code>, which should be a valid RFC 2822 date format:\n\n<pre>d = Date.new(2001, ...</pre>\n"],["_rfc3339","Date","Date.html#method-c-_rfc3339","(p1, p2 = {})","<p>Returns a hash of values parsed from <code>string</code>, which should be a valid RFC 3339 format:\n\n<pre>d = Date.new(2001, ...</pre>\n"],["_rfc822","Date","Date.html#method-c-_rfc822","(p1, p2 = {})","<p>Returns a hash of values parsed from <code>string</code>, which should be a valid RFC 2822 date format:\n\n<pre>d = Date.new(2001, ...</pre>\n"],["_strptime","Date","Date.html#method-c-_strptime","(*args)","<p>Returns a hash of values parsed from <code>string</code> according to the given <code>format</code>:\n\n<pre>Date._strptime(&#39;2001-02-03&#39;, ...</pre>\n"],["_strptime","DateTime","DateTime.html#method-c-_strptime","(*args)","<p>Parses the given representation of date and time with the given template, and returns a hash of parsed …\n"],["_xmlschema","Date","Date.html#method-c-_xmlschema","(p1, p2 = {})","<p>Returns a hash of values parsed from <code>string</code>, which should be a valid XML date format:\n\n<pre>d = Date.new(2001, ...</pre>\n"],["ajd","Date","Date.html#method-i-ajd","()","<p>Returns the astronomical Julian day number.  This is a fractional number, which is not adjusted by the …\n"],["amjd","Date","Date.html#method-i-amjd","()","<p>Returns the astronomical modified Julian day number.  This is a fractional number, which is not adjusted …\n"],["asctime","Date","Date.html#method-i-asctime","()","<p>Equivalent to #strftime with argument <code>&#39;%a %b %e %T %Y&#39;</code> (or its shorthand form <code>&#39;%c&#39;</code>): …\n"],["civil","Date","Date.html#method-c-civil","(*args)","<p>Same as Date.new.\n"],["civil","DateTime","DateTime.html#method-c-civil","(*args)","<p>Same as DateTime.new.\n"],["commercial","Date","Date.html#method-c-commercial","(p1 = v1, p2 = v2, p3 = v3, p4 = v4)","<p>Returns a new Date object constructed from the arguments.\n<p>Argument <code>cwyear</code> gives the year, and should be …\n"],["commercial","DateTime","DateTime.html#method-c-commercial","(p1 = v1, p2 = v2, p3 = v3, p4 = v4, p5 = v5, p6 = v6, p7 = v7, p8 = v8)","<p>Creates a DateTime object denoting the given week date.\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">DateTime</span>.<span class=\"ruby-identifier\">commercial</span>(<span class=\"ruby-value\">2001</span>) <span class=\"ruby-comment\">#=&gt; #&lt;DateTime: 2001-01-01T00:00:00+00:00 ...</span>\n</pre>\n"],["ctime","Date","Date.html#method-i-ctime","()","<p>Equivalent to #strftime with argument <code>&#39;%a %b %e %T %Y&#39;</code> (or its shorthand form <code>&#39;%c&#39;</code>): …\n"],["cwday","Date","Date.html#method-i-cwday","()","<p>Returns the commercial-date weekday index for <code>self</code> (see Date.commercial); 1 is Monday:\n\n<pre>Date.new(2001, ...</pre>\n"],["cweek","Date","Date.html#method-i-cweek","()","<p>Returns commercial-date week index for <code>self</code> (see Date.commercial):\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">Date</span>.<span class=\"ruby-identifier\">new</span>(<span class=\"ruby-value\">2001</span>, <span class=\"ruby-value\">2</span>, <span class=\"ruby-value\">3</span>).<span class=\"ruby-identifier\">cweek</span> <span class=\"ruby-comment\"># =&gt; 5</span>\n</pre>\n"],["cwyear","Date","Date.html#method-i-cwyear","()","<p>Returns commercial-date year for <code>self</code> (see Date.commercial):\n\n<pre>Date.new(2001, 2, 3).cwyear # =&gt; 2001\nDate.new(2000, ...</pre>\n"],["day","Date","Date.html#method-i-day","()","<p>Returns the day of the month in range (1..31):\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">Date</span>.<span class=\"ruby-identifier\">new</span>(<span class=\"ruby-value\">2001</span>, <span class=\"ruby-value\">2</span>, <span class=\"ruby-value\">3</span>).<span class=\"ruby-identifier\">mday</span> <span class=\"ruby-comment\"># =&gt; 3</span>\n</pre>\n"],["day_fraction","Date","Date.html#method-i-day_fraction","()","<p>Returns the fractional part of the day in range (Rational(0, 1)…Rational(1, 1)):\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">DateTime</span>.<span class=\"ruby-identifier\">new</span>(<span class=\"ruby-value\">2001</span>,<span class=\"ruby-value\">2</span>,<span class=\"ruby-value\">3</span>,<span class=\"ruby-value\">12</span>).<span class=\"ruby-identifier\">day_fraction</span> <span class=\"ruby-operator\">...</span>\n</pre>\n"],["deconstruct_keys","Date","Date.html#method-i-deconstruct_keys","(p1)","<p>Returns a hash of the name/value pairs, to use in pattern matching. Possible keys are: <code>:year</code>, <code>:month</code> …\n"],["deconstruct_keys","DateTime","DateTime.html#method-i-deconstruct_keys","(p1)","<p>Returns a hash of the name/value pairs, to use in pattern matching. Possible keys are: <code>:year</code>, <code>:month</code> …\n"],["downto","Date","Date.html#method-i-downto","(p1)","<p>Equivalent to #step with arguments <code>min</code> and <code>-1</code>.\n"],["england","Date","Date.html#method-i-england","()","<p>Equivalent to Date#new_start with argument Date::ENGLAND.\n"],["friday?","Date","Date.html#method-i-friday-3F","()","<p>Returns <code>true</code> if <code>self</code> is a Friday, <code>false</code> otherwise.\n"],["gregorian","Date","Date.html#method-i-gregorian","()","<p>Equivalent to Date#new_start with argument Date::GREGORIAN.\n"],["gregorian?","Date","Date.html#method-i-gregorian-3F","()","<p>Returns <code>true</code> if the date is on or after the date of calendar reform, <code>false</code> otherwise:\n\n<pre>Date.new(1582, 10, ...</pre>\n"],["gregorian_leap?","Date","Date.html#method-c-gregorian_leap-3F","(p1)","<p>Returns <code>true</code> if the given year is a leap year in the proleptic Gregorian calendar, <code>false</code> otherwise:\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">Date</span>.<span class=\"ruby-identifier\">gregorian_leap?</span>(<span class=\"ruby-value\">2000</span>) <span class=\"ruby-operator\">...</span>\n</pre>\n"],["hour","DateTime","DateTime.html#method-i-hour","()","<p>Returns the hour in range (0..23):\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">DateTime</span>.<span class=\"ruby-identifier\">new</span>(<span class=\"ruby-value\">2001</span>, <span class=\"ruby-value\">2</span>, <span class=\"ruby-value\">3</span>, <span class=\"ruby-value\">4</span>, <span class=\"ruby-value\">5</span>, <span class=\"ruby-value\">6</span>).<span class=\"ruby-identifier\">hour</span> <span class=\"ruby-comment\"># =&gt; 4</span>\n</pre>\n"],["httpdate","Date","Date.html#method-c-httpdate","(p1 = v1, p2 = v2, p3 = {})","<p>Returns a new Date object with values parsed from <code>string</code>, which should be a valid HTTP date format:\n\n<pre class=\"ruby\"><span class=\"ruby-identifier\">d</span> <span class=\"ruby-operator\">...</span>\n</pre>\n"],["httpdate","Date","Date.html#method-i-httpdate","()","<p>Equivalent to #strftime with argument <code>&#39;%a, %d %b %Y %T GMT&#39;</code>; see Formats for Dates and Times …\n"],["httpdate","DateTime","DateTime.html#method-c-httpdate","(p1 = v1, p2 = v2, p3 = {})","<p>Creates a new DateTime object by parsing from a string according to some RFC 2616 format.\n\n<pre>DateTime.httpdate(&#39;Sat, ...</pre>\n"],["infinite?","Date","Date.html#method-i-infinite-3F","()","<p>Returns <code>false</code>\n"],["inspect","Date","Date.html#method-i-inspect","()","<p>Returns a string representation of <code>self</code>:\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">Date</span>.<span class=\"ruby-identifier\">new</span>(<span class=\"ruby-value\">2001</span>, <span class=\"ruby-value\">2</span>, <span class=\"ruby-value\">3</span>).<span class=\"ruby-identifier\">inspect</span>\n<span class=\"ruby-comment\"># =&gt; &quot;#&lt;Date: 2001-02-03 ((2451944j,0s,0n),+0s,2299161j)&gt;&quot;</span>\n</pre>\n"],["iso8601","Date","Date.html#method-c-iso8601","(p1 = v1, p2 = v2, p3 = {})","<p>Returns a new Date object with values parsed from <code>string</code>, which should contain an ISO 8601 formatted …\n"],["iso8601","Date","Date.html#method-i-iso8601","()","<p>Equivalent to #strftime with argument <code>&#39;%Y-%m-%d&#39;</code> (or its shorthand form <code>&#39;%F&#39;</code>);\n\n<pre>Date.new(2001, ...</pre>\n"],["iso8601","DateTime","DateTime.html#method-c-iso8601","(p1 = v1, p2 = v2, p3 = {})","<p>Creates a new DateTime object by parsing from a string according to some typical ISO 8601 formats.\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">DateTime</span>.<span class=\"ruby-identifier\">iso8601</span>(<span class=\"ruby-string\">&#39;2001-02-03T04:05:06+07:00&#39;</span>) <span class=\"ruby-operator\">...</span>\n</pre>\n"],["iso8601","DateTime","DateTime.html#method-i-iso8601","(*args)","<p>This method is equivalent to strftime(‘%FT%T%:z’). The optional argument <code>n</code> is the number of digits …\n"],["italy","Date","Date.html#method-i-italy","()","<p>Equivalent to Date#new_start with argument Date::ITALY.\n"],["jd","Date","Date.html#method-c-jd","(p1 = v1, p2 = v2)","<p>Returns a new Date object formed from the arguments:\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">Date</span>.<span class=\"ruby-identifier\">jd</span>(<span class=\"ruby-value\">2451944</span>).<span class=\"ruby-identifier\">to_s</span> <span class=\"ruby-comment\"># =&gt; &quot;2001-02-03&quot;</span>\n<span class=\"ruby-constant\">Date</span>.<span class=\"ruby-identifier\">jd</span>(<span class=\"ruby-value\">2451945</span>).<span class=\"ruby-identifier\">to_s</span> <span class=\"ruby-operator\">...</span>\n</pre>\n"],["jd","Date","Date.html#method-i-jd","()","<p>Returns the Julian day number.  This is a whole number, which is adjusted by the offset as the local …\n"],["jd","DateTime","DateTime.html#method-c-jd","(p1 = v1, p2 = v2, p3 = v3, p4 = v4, p5 = v5, p6 = v6)","<p>Creates a DateTime object denoting the given chronological Julian day number.\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">DateTime</span>.<span class=\"ruby-identifier\">jd</span>(<span class=\"ruby-value\">2451944</span>)    <span class=\"ruby-operator\">...</span>\n</pre>\n"],["jisx0301","Date","Date.html#method-c-jisx0301","(p1 = v1, p2 = v2, p3 = {})","<p>Returns a new Date object with values parsed from <code>string</code>, which should be a valid JIS X 0301 format: …\n"],["jisx0301","Date","Date.html#method-i-jisx0301","()","<p>Returns a string representation of the date in <code>self</code> in JIS X 0301 format.\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">Date</span>.<span class=\"ruby-identifier\">new</span>(<span class=\"ruby-value\">2001</span>, <span class=\"ruby-value\">2</span>, <span class=\"ruby-value\">3</span>).<span class=\"ruby-identifier\">jisx0301</span> <span class=\"ruby-operator\">...</span>\n</pre>\n"],["jisx0301","DateTime","DateTime.html#method-c-jisx0301","(p1 = v1, p2 = v2, p3 = {})","<p>Creates a new DateTime object by parsing from a string according to some typical JIS X 0301 formats. …\n"],["jisx0301","DateTime","DateTime.html#method-i-jisx0301","(*args)","<p>Returns a string in a JIS X 0301 format. The optional argument <code>n</code> is the number of digits for fractional …\n"],["julian","Date","Date.html#method-i-julian","()","<p>Equivalent to Date#new_start with argument Date::JULIAN.\n"],["julian?","Date","Date.html#method-i-julian-3F","()","<p>Returns <code>true</code> if the date is before the date of calendar reform, <code>false</code> otherwise:\n\n<pre>(Date.new(1582, 10, 15) ...</pre>\n"],["julian_leap?","Date","Date.html#method-c-julian_leap-3F","(p1)","<p>Returns <code>true</code> if the given year is a leap year in the proleptic Julian calendar, <code>false</code> otherwise:\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">Date</span>.<span class=\"ruby-identifier\">julian_leap?</span>(<span class=\"ruby-value\">1900</span>) <span class=\"ruby-operator\">...</span>\n</pre>\n"],["ld","Date","Date.html#method-i-ld","()","<p>Returns the Lilian day number, which is the number of days since the beginning of the Gregorian calendar, …\n"],["leap?","Date","Date.html#method-c-leap-3F","(p1)","<p>Returns <code>true</code> if the given year is a leap year in the proleptic Gregorian calendar, <code>false</code> otherwise:\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">Date</span>.<span class=\"ruby-identifier\">gregorian_leap?</span>(<span class=\"ruby-value\">2000</span>) <span class=\"ruby-operator\">...</span>\n</pre>\n"],["leap?","Date","Date.html#method-i-leap-3F","()","<p>Returns <code>true</code> if the year is a leap year, <code>false</code> otherwise:\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">Date</span>.<span class=\"ruby-identifier\">new</span>(<span class=\"ruby-value\">2000</span>).<span class=\"ruby-identifier\">leap?</span> <span class=\"ruby-comment\"># =&gt; true</span>\n<span class=\"ruby-constant\">Date</span>.<span class=\"ruby-identifier\">new</span>(<span class=\"ruby-value\">2001</span>).<span class=\"ruby-identifier\">leap?</span> <span class=\"ruby-operator\">...</span>\n</pre>\n"],["mday","Date","Date.html#method-i-mday","()","<p>Returns the day of the month in range (1..31):\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">Date</span>.<span class=\"ruby-identifier\">new</span>(<span class=\"ruby-value\">2001</span>, <span class=\"ruby-value\">2</span>, <span class=\"ruby-value\">3</span>).<span class=\"ruby-identifier\">mday</span> <span class=\"ruby-comment\"># =&gt; 3</span>\n</pre>\n"],["min","DateTime","DateTime.html#method-i-min","()","<p>Returns the minute in range (0..59):\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">DateTime</span>.<span class=\"ruby-identifier\">new</span>(<span class=\"ruby-value\">2001</span>, <span class=\"ruby-value\">2</span>, <span class=\"ruby-value\">3</span>, <span class=\"ruby-value\">4</span>, <span class=\"ruby-value\">5</span>, <span class=\"ruby-value\">6</span>).<span class=\"ruby-identifier\">min</span> <span class=\"ruby-comment\"># =&gt; 5</span>\n</pre>\n"],["minute","DateTime","DateTime.html#method-i-minute","()","<p>Returns the minute in range (0..59):\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">DateTime</span>.<span class=\"ruby-identifier\">new</span>(<span class=\"ruby-value\">2001</span>, <span class=\"ruby-value\">2</span>, <span class=\"ruby-value\">3</span>, <span class=\"ruby-value\">4</span>, <span class=\"ruby-value\">5</span>, <span class=\"ruby-value\">6</span>).<span class=\"ruby-identifier\">min</span> <span class=\"ruby-comment\"># =&gt; 5</span>\n</pre>\n"],["mjd","Date","Date.html#method-i-mjd","()","<p>Returns the modified Julian day number.  This is a whole number, which is adjusted by the offset as the …\n"],["mon","Date","Date.html#method-i-mon","()","<p>Returns the month in range (1..12):\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">Date</span>.<span class=\"ruby-identifier\">new</span>(<span class=\"ruby-value\">2001</span>, <span class=\"ruby-value\">2</span>, <span class=\"ruby-value\">3</span>).<span class=\"ruby-identifier\">mon</span> <span class=\"ruby-comment\"># =&gt; 2</span>\n</pre>\n"],["monday?","Date","Date.html#method-i-monday-3F","()","<p>Returns <code>true</code> if <code>self</code> is a Monday, <code>false</code> otherwise.\n"],["month","Date","Date.html#method-i-month","()","<p>Returns the month in range (1..12):\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">Date</span>.<span class=\"ruby-identifier\">new</span>(<span class=\"ruby-value\">2001</span>, <span class=\"ruby-value\">2</span>, <span class=\"ruby-value\">3</span>).<span class=\"ruby-identifier\">mon</span> <span class=\"ruby-comment\"># =&gt; 2</span>\n</pre>\n"],["new","Date","Date.html#method-c-new","(p1 = v1, p2 = v2, p3 = v3, p4 = v4)","<p>Returns a new Date object constructed from the given arguments:\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">Date</span>.<span class=\"ruby-identifier\">new</span>(<span class=\"ruby-value\">2022</span>).<span class=\"ruby-identifier\">to_s</span>        <span class=\"ruby-comment\"># =&gt; &quot;2022-01-01&quot; ...</span>\n</pre>\n"],["new","DateTime","DateTime.html#method-c-new","(*args)","<p>Same as DateTime.new.\n"],["new_offset","DateTime","DateTime.html#method-i-new_offset","(p1 = v1)","<p>Duplicates self and resets its offset.\n\n<pre>d = DateTime.new(2001,2,3,4,5,6,&#39;-02:00&#39;)\n                     ...</pre>\n"],["new_start","Date","Date.html#method-i-new_start","(p1 = v1)","<p>Returns a copy of <code>self</code> with the given <code>start</code> value:\n\n<pre class=\"ruby\"><span class=\"ruby-identifier\">d0</span> = <span class=\"ruby-constant\">Date</span>.<span class=\"ruby-identifier\">new</span>(<span class=\"ruby-value\">2000</span>, <span class=\"ruby-value\">2</span>, <span class=\"ruby-value\">3</span>)\n<span class=\"ruby-identifier\">d0</span>.<span class=\"ruby-identifier\">julian?</span> <span class=\"ruby-comment\"># =&gt; false</span>\n<span class=\"ruby-identifier\">d1</span> <span class=\"ruby-operator\">...</span>\n</pre>\n"],["next","Date","Date.html#method-i-next","()","<p>Returns a new Date object representing the following day:\n\n<pre class=\"ruby\"><span class=\"ruby-identifier\">d</span> = <span class=\"ruby-constant\">Date</span>.<span class=\"ruby-identifier\">new</span>(<span class=\"ruby-value\">2001</span>, <span class=\"ruby-value\">2</span>, <span class=\"ruby-value\">3</span>)\n<span class=\"ruby-identifier\">d</span>.<span class=\"ruby-identifier\">to_s</span>      <span class=\"ruby-comment\"># =&gt; &quot;2001-02-03&quot; ...</span>\n</pre>\n"],["next_day","Date","Date.html#method-i-next_day","(p1 = v1)","<p>Equivalent to Date#+ with argument <code>n</code>.\n"],["next_month","Date","Date.html#method-i-next_month","(p1 = v1)","<p>Equivalent to #>> with argument <code>n</code>.\n"],["next_year","Date","Date.html#method-i-next_year","(p1 = v1)","<p>Equivalent to #>> with argument <code>n * 12</code>.\n"],["now","DateTime","DateTime.html#method-c-now","(p1 = v1)","<p>Creates a DateTime object denoting the present time.\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">DateTime</span>.<span class=\"ruby-identifier\">now</span>              <span class=\"ruby-comment\">#=&gt; #&lt;DateTime: 2011-06-11T21:20:44+09:00 ...</span>\n</pre>\n"],["offset","DateTime","DateTime.html#method-i-offset","()","<p>Returns the offset.\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">DateTime</span>.<span class=\"ruby-identifier\">parse</span>(<span class=\"ruby-string\">&#39;04pm+0730&#39;</span>).<span class=\"ruby-identifier\">offset</span>        <span class=\"ruby-comment\">#=&gt; (5/16)</span>\n</pre>\n"],["ordinal","Date","Date.html#method-c-ordinal","(p1 = v1, p2 = v2, p3 = v3)","<p>Returns a new Date object formed fom the arguments.\n<p>With no arguments, returns the date for January 1, …\n"],["ordinal","DateTime","DateTime.html#method-c-ordinal","(p1 = v1, p2 = v2, p3 = v3, p4 = v4, p5 = v5, p6 = v6, p7 = v7)","<p>Creates a DateTime object denoting the given ordinal date.\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">DateTime</span>.<span class=\"ruby-identifier\">ordinal</span>(<span class=\"ruby-value\">2001</span>,<span class=\"ruby-value\">34</span>) <span class=\"ruby-comment\">#=&gt; #&lt;DateTime: 2001-02-03T00:00:00+00:00 ...</span>\n</pre>\n"],["parse","Date","Date.html#method-c-parse","(p1 = v1, p2 = v2, p3 = v3, p4 = {})","<p><strong>Note</strong>: This method recognizes many forms in <code>string</code>, but it is not a validator. For formats, see “Specialized …\n"],["parse","DateTime","DateTime.html#method-c-parse","(p1 = v1, p2 = v2, p3 = v3, p4 = {})","<p>Parses the given representation of date and time, and creates a DateTime object.\n<p>This method <strong>does</strong> <strong>not</strong> …\n"],["prev_day","Date","Date.html#method-i-prev_day","(p1 = v1)","<p>Equivalent to Date#- with argument <code>n</code>.\n"],["prev_month","Date","Date.html#method-i-prev_month","(p1 = v1)","<p>Equivalent to #<< with argument <code>n</code>.\n"],["prev_year","Date","Date.html#method-i-prev_year","(p1 = v1)","<p>Equivalent to #<< with argument <code>n * 12</code>.\n"],["rfc2822","Date","Date.html#method-c-rfc2822","(p1 = v1, p2 = v2, p3 = {})","<p>Returns a new Date object with values parsed from <code>string</code>, which should be a valid RFC 2822 date format …\n"],["rfc2822","Date","Date.html#method-i-rfc2822","()","<p>Equivalent to #strftime with argument <code>&#39;%a, %-d %b %Y %T %z&#39;</code>; see Formats for Dates and Times …\n"],["rfc2822","DateTime","DateTime.html#method-c-rfc2822","(p1 = v1, p2 = v2, p3 = {})","<p>Creates a new DateTime object by parsing from a string according to some typical RFC 2822 formats.\n\n<pre>DateTime.rfc2822(&#39;Sat, ...</pre>\n"],["rfc3339","Date","Date.html#method-c-rfc3339","(p1 = v1, p2 = v2, p3 = {})","<p>Returns a new Date object with values parsed from <code>string</code>, which should be a valid RFC 3339 format:\n\n<pre>d = ...</pre>\n"],["rfc3339","Date","Date.html#method-i-rfc3339","()","<p>Equivalent to #strftime with argument <code>&#39;%FT%T%:z&#39;</code>; see Formats for Dates and Times:\n\n<pre>Date.new(2001, ...</pre>\n"],["rfc3339","DateTime","DateTime.html#method-c-rfc3339","(p1 = v1, p2 = v2, p3 = {})","<p>Creates a new DateTime object by parsing from a string according to some typical RFC 3339 formats.\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">DateTime</span>.<span class=\"ruby-identifier\">rfc3339</span>(<span class=\"ruby-string\">&#39;2001-02-03T04:05:06+07:00&#39;</span>) <span class=\"ruby-operator\">...</span>\n</pre>\n"],["rfc3339","DateTime","DateTime.html#method-i-rfc3339","(*args)","<p>This method is equivalent to strftime(‘%FT%T%:z’). The optional argument <code>n</code> is the number of digits …\n"],["rfc822","Date","Date.html#method-c-rfc822","(p1 = v1, p2 = v2, p3 = {})","<p>Returns a new Date object with values parsed from <code>string</code>, which should be a valid RFC 2822 date format …\n"],["rfc822","Date","Date.html#method-i-rfc822","()","<p>Returns a new Date object with values parsed from <code>string</code>, which should be a valid RFC 2822 date format …\n"],["rfc822","DateTime","DateTime.html#method-c-rfc822","(p1 = v1, p2 = v2, p3 = {})","<p>Creates a new DateTime object by parsing from a string according to some typical RFC 2822 formats.\n\n<pre>DateTime.rfc2822(&#39;Sat, ...</pre>\n"],["saturday?","Date","Date.html#method-i-saturday-3F","()","<p>Returns <code>true</code> if <code>self</code> is a Saturday, <code>false</code> otherwise.\n"],["sec","DateTime","DateTime.html#method-i-sec","()","<p>Returns the second in range (0..59):\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">DateTime</span>.<span class=\"ruby-identifier\">new</span>(<span class=\"ruby-value\">2001</span>, <span class=\"ruby-value\">2</span>, <span class=\"ruby-value\">3</span>, <span class=\"ruby-value\">4</span>, <span class=\"ruby-value\">5</span>, <span class=\"ruby-value\">6</span>).<span class=\"ruby-identifier\">sec</span> <span class=\"ruby-comment\"># =&gt; 6</span>\n</pre>\n"],["sec_fraction","DateTime","DateTime.html#method-i-sec_fraction","()","<p>Returns the fractional part of the second in range (Rational(0, 1)…Rational(1, 1)):\n\n<pre>DateTime.new(2001, ...</pre>\n"],["second","DateTime","DateTime.html#method-i-second","()","<p>Returns the second in range (0..59):\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">DateTime</span>.<span class=\"ruby-identifier\">new</span>(<span class=\"ruby-value\">2001</span>, <span class=\"ruby-value\">2</span>, <span class=\"ruby-value\">3</span>, <span class=\"ruby-value\">4</span>, <span class=\"ruby-value\">5</span>, <span class=\"ruby-value\">6</span>).<span class=\"ruby-identifier\">sec</span> <span class=\"ruby-comment\"># =&gt; 6</span>\n</pre>\n"],["second_fraction","DateTime","DateTime.html#method-i-second_fraction","()","<p>Returns the fractional part of the second in range (Rational(0, 1)…Rational(1, 1)):\n\n<pre>DateTime.new(2001, ...</pre>\n"],["start","Date","Date.html#method-i-start","()","<p>Returns the Julian start date for calendar reform; if not an infinity, the returned value is suitable …\n"],["step","Date","Date.html#method-i-step","(p1, p2 = v2)","<p>Calls the block with specified dates; returns <code>self</code>.\n<p>The first <code>date</code> is <code>self</code>.\n<p>Each successive <code>date</code> is <code>date</code> …\n"],["strftime","Date","Date.html#method-i-strftime","(*args)","<p>Returns a string representation of the date in <code>self</code>, formatted according the given <code>format</code>:\n\n<pre>Date.new(2001, ...</pre>\n"],["strftime","DateTime","DateTime.html#method-i-strftime","(*args)","<p>Returns a string representation of <code>self</code>, formatted according the given +format:\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">DateTime</span>.<span class=\"ruby-identifier\">now</span>.<span class=\"ruby-identifier\">strftime</span> <span class=\"ruby-operator\">...</span>\n</pre>\n"],["strptime","Date","Date.html#method-c-strptime","(p1 = v1, p2 = v2, p3 = v3)","<p>Returns a new Date object with values parsed from <code>string</code>, according to the given <code>format</code>:\n\n<pre>Date.strptime(&#39;2001-02-03&#39;, ...</pre>\n"],["strptime","DateTime","DateTime.html#method-c-strptime","(p1 = v1, p2 = v2, p3 = v3)","<p>Parses the given representation of date and time with the given template, and creates a DateTime object. …\n"],["succ","Date","Date.html#method-i-succ","()","<p>Returns a new Date object representing the following day:\n\n<pre class=\"ruby\"><span class=\"ruby-identifier\">d</span> = <span class=\"ruby-constant\">Date</span>.<span class=\"ruby-identifier\">new</span>(<span class=\"ruby-value\">2001</span>, <span class=\"ruby-value\">2</span>, <span class=\"ruby-value\">3</span>)\n<span class=\"ruby-identifier\">d</span>.<span class=\"ruby-identifier\">to_s</span>      <span class=\"ruby-comment\"># =&gt; &quot;2001-02-03&quot; ...</span>\n</pre>\n"],["sunday?","Date","Date.html#method-i-sunday-3F","()","<p>Returns <code>true</code> if <code>self</code> is a Sunday, <code>false</code> otherwise.\n"],["thursday?","Date","Date.html#method-i-thursday-3F","()","<p>Returns <code>true</code> if <code>self</code> is a Thursday, <code>false</code> otherwise.\n"],["to_date","Date","Date.html#method-i-to_date","()","<p>Returns <code>self</code>.\n"],["to_date","DateTime","DateTime.html#method-i-to_date","()","<p>Returns a Date object which denotes self.\n"],["to_date","Time","Time.html#method-i-to_date","()","<p>Returns a Date object which denotes self.\n"],["to_datetime","Date","Date.html#method-i-to_datetime","()","<p>Returns a DateTime whose value is the same as <code>self</code>:\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">Date</span>.<span class=\"ruby-identifier\">new</span>(<span class=\"ruby-value\">2001</span>, <span class=\"ruby-value\">2</span>, <span class=\"ruby-value\">3</span>).<span class=\"ruby-identifier\">to_datetime</span> <span class=\"ruby-comment\"># =&gt; #&lt;DateTime: ...</span>\n</pre>\n"],["to_datetime","DateTime","DateTime.html#method-i-to_datetime","()","<p>Returns self.\n"],["to_datetime","Time","Time.html#method-i-to_datetime","()","<p>Returns a DateTime object which denotes self.\n"],["to_s","Date","Date.html#method-i-to_s","()","<p>Returns a string representation of the date in <code>self</code> in ISO 8601 extended date format (<code>&#39;%Y-%m-%d&#39;</code> …\n"],["to_s","DateTime","DateTime.html#method-i-to_s","()","<p>Returns a string in an ISO 8601 format. (This method doesn’t use the expanded representations.)\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">DateTime</span>.<span class=\"ruby-identifier\">new</span>(<span class=\"ruby-value\">2001</span>,<span class=\"ruby-value\">2</span>,<span class=\"ruby-value\">3</span>,<span class=\"ruby-value\">4</span>,<span class=\"ruby-value\">5</span>,<span class=\"ruby-value\">6</span>,<span class=\"ruby-string\">&#39;-7&#39;</span>).<span class=\"ruby-identifier\">to_s</span> <span class=\"ruby-operator\">...</span>\n</pre>\n"],["to_time","Date","Date.html#method-i-to_time","()","<p>Returns a new Time object with the same value as <code>self</code>; if <code>self</code> is a Julian date, derives its Gregorian …\n"],["to_time","DateTime","DateTime.html#method-i-to_time","()","<p>Returns a Time object which denotes self.\n"],["to_time","Time","Time.html#method-i-to_time","()","<p>Returns self.\n"],["today","Date","Date.html#method-c-today","(p1 = v1)","<p>Returns a new Date object constructed from the present date:\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">Date</span>.<span class=\"ruby-identifier\">today</span>.<span class=\"ruby-identifier\">to_s</span> <span class=\"ruby-comment\"># =&gt; &quot;2022-07-06&quot;</span>\n</pre>\n<p>See argument …\n"],["tuesday?","Date","Date.html#method-i-tuesday-3F","()","<p>Returns <code>true</code> if <code>self</code> is a Tuesday, <code>false</code> otherwise.\n"],["upto","Date","Date.html#method-i-upto","(p1)","<p>Equivalent to #step with arguments <code>max</code> and <code>1</code>.\n"],["valid_civil?","Date","Date.html#method-c-valid_civil-3F","(p1, p2, p3, p4 = v4)","<p>Returns <code>true</code> if the arguments define a valid ordinal date, <code>false</code> otherwise:\n\n<pre>Date.valid_date?(2001, 2, ...</pre>\n"],["valid_commercial?","Date","Date.html#method-c-valid_commercial-3F","(p1, p2, p3, p4 = v4)","<p>Returns <code>true</code> if the arguments define a valid commercial date, <code>false</code> otherwise:\n\n<pre>Date.valid_commercial?(2001, ...</pre>\n"],["valid_date?","Date","Date.html#method-c-valid_date-3F","(p1, p2, p3, p4 = v4)","<p>Returns <code>true</code> if the arguments define a valid ordinal date, <code>false</code> otherwise:\n\n<pre>Date.valid_date?(2001, 2, ...</pre>\n"],["valid_jd?","Date","Date.html#method-c-valid_jd-3F","(p1, p2 = v2)","<p>Implemented for compatibility; returns <code>true</code> unless <code>jd</code> is invalid (i.e., not a Numeric).\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">Date</span>.<span class=\"ruby-identifier\">valid_jd?</span>(<span class=\"ruby-value\">2451944</span>) <span class=\"ruby-operator\">...</span>\n</pre>\n"],["valid_ordinal?","Date","Date.html#method-c-valid_ordinal-3F","(p1, p2, p3 = v3)","<p>Returns <code>true</code> if the arguments define a valid ordinal date, <code>false</code> otherwise:\n\n<pre>Date.valid_ordinal?(2001, ...</pre>\n"],["wday","Date","Date.html#method-i-wday","()","<p>Returns the day of week in range (0..6); Sunday is 0:\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">Date</span>.<span class=\"ruby-identifier\">new</span>(<span class=\"ruby-value\">2001</span>, <span class=\"ruby-value\">2</span>, <span class=\"ruby-value\">3</span>).<span class=\"ruby-identifier\">wday</span> <span class=\"ruby-comment\"># =&gt; 6</span>\n</pre>\n"],["wednesday?","Date","Date.html#method-i-wednesday-3F","()","<p>Returns <code>true</code> if <code>self</code> is a Wednesday, <code>false</code> otherwise.\n"],["xmlschema","Date","Date.html#method-c-xmlschema","(p1 = v1, p2 = v2, p3 = {})","<p>Returns a new Date object with values parsed from <code>string</code>, which should be a valid XML date format:\n\n<pre>d = ...</pre>\n"],["xmlschema","Date","Date.html#method-i-xmlschema","()","<p>Equivalent to #strftime with argument <code>&#39;%Y-%m-%d&#39;</code> (or its shorthand form <code>&#39;%F&#39;</code>);\n\n<pre>Date.new(2001, ...</pre>\n"],["xmlschema","DateTime","DateTime.html#method-c-xmlschema","(p1 = v1, p2 = v2, p3 = {})","<p>Creates a new DateTime object by parsing from a string according to some typical XML Schema formats. …\n"],["xmlschema","DateTime","DateTime.html#method-i-xmlschema","(*args)","<p>This method is equivalent to strftime(‘%FT%T%:z’). The optional argument <code>n</code> is the number of digits …\n"],["yday","Date","Date.html#method-i-yday","()","<p>Returns the day of the year, in range (1..366):\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">Date</span>.<span class=\"ruby-identifier\">new</span>(<span class=\"ruby-value\">2001</span>, <span class=\"ruby-value\">2</span>, <span class=\"ruby-value\">3</span>).<span class=\"ruby-identifier\">yday</span> <span class=\"ruby-comment\"># =&gt; 34</span>\n</pre>\n"],["year","Date","Date.html#method-i-year","()","<p>Returns the year:\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">Date</span>.<span class=\"ruby-identifier\">new</span>(<span class=\"ruby-value\">2001</span>, <span class=\"ruby-value\">2</span>, <span class=\"ruby-value\">3</span>).<span class=\"ruby-identifier\">year</span>    <span class=\"ruby-comment\"># =&gt; 2001</span>\n(<span class=\"ruby-constant\">Date</span>.<span class=\"ruby-identifier\">new</span>(<span class=\"ruby-value\">1</span>, <span class=\"ruby-value\">1</span>, <span class=\"ruby-value\">1</span>) <span class=\"ruby-operator\">-</span> <span class=\"ruby-value\">1</span>).<span class=\"ruby-identifier\">year</span> <span class=\"ruby-comment\"># =&gt; 0</span>\n</pre>\n"],["zone","DateTime","DateTime.html#method-i-zone","()","<p>Returns the timezone.\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">DateTime</span>.<span class=\"ruby-identifier\">parse</span>(<span class=\"ruby-string\">&#39;04pm+0730&#39;</span>).<span class=\"ruby-identifier\">zone</span>          <span class=\"ruby-comment\">#=&gt; &quot;+07:30&quot;</span>\n</pre>\n"]]}}