var search_data = {"index":{"searchIndex":["addrinfo","basicsocket","ipsocket","object","sockssocket","socket","ancillarydata","constants","hostnameresolutionresult","hostnameresolutionstore","ifaddr","option","resolutionerror","udpsource","socketerror","tcpserver","tcpsocket","udpsocket","unixserver","unixsocket","accept()","accept()","accept()","accept_loop()","accept_nonblock()","accept_nonblock()","accept_nonblock()","add()","add_error()","add_resolved()","addr()","addr()","addr()","afamily()","any_addrinfos?()","any_unresolved_family?()","bind()","bind()","bind()","bool()","bool()","broadaddr()","byte()","byte()","c_str()","canonname()","close()","close()","close_read()","close_write()","cmsg_is?()","connect()","connect()","connect()","connect_address()","connect_from()","connect_internal()","connect_nonblock()","connect_to()","current_clock_time()","data()","data()","def_intern()","def_name_to_int()","do_not_reverse_lookup()","do_not_reverse_lookup()","do_not_reverse_lookup=()","do_not_reverse_lookup=()","dstaddr()","each_const()","each_name()","each_names_with_len()","empty_addrinfos?()","error_code()","expired?()","family()","family()","family_addrinfo()","flags()","for_fd()","foreach()","get()","get_addrinfo()","getaddress()","getaddrinfo()","getaddrinfo()","gethostbyaddr()","gethostbyname()","gethostbyname()","gethostname()","getifaddrs()","getnameinfo()","getnameinfo()","getpeereid()","getpeername()","getservbyname()","getservbyport()","getsockname()","getsockopt()","ifindex()","inspect()","inspect()","inspect()","inspect()","inspect()","inspect_sockaddr()","int()","int()","int()","int()","ip()","ip?()","ip_address()","ip_address?()","ip_address_list()","ip_pktinfo()","ip_pktinfo()","ip_port()","ip_unpack()","ipv4?()","ipv4_loopback?()","ipv4_multicast?()","ipv4_multicast_loop()","ipv4_multicast_loop()","ipv4_multicast_ttl()","ipv4_multicast_ttl()","ipv4_private?()","ipv6?()","ipv6_linklocal?()","ipv6_loopback?()","ipv6_mc_global?()","ipv6_mc_linklocal?()","ipv6_mc_nodelocal?()","ipv6_mc_orglocal?()","ipv6_mc_sitelocal?()","ipv6_multicast?()","ipv6_pktinfo()","ipv6_pktinfo()","ipv6_pktinfo_addr()","ipv6_pktinfo_ifindex()","ipv6_sitelocal?()","ipv6_to_ipv4()","ipv6_unique_local?()","ipv6_unspecified?()","ipv6_v4compat?()","ipv6_v4mapped?()","ipv6only!()","level()","level()","linger()","linger()","listen()","listen()","listen()","listen()","local_address()","name()","netmask()","new()","new()","new()","new()","new()","new()","new()","new()","new()","new()","new()","new()","new()","notifier()","optname()","pack_sockaddr_in()","pack_sockaddr_un()","pair()","pair()","path()","peeraddr()","peeraddr()","pfamily()","protocol()","recv()","recv_io()","recv_nonblock()","recvfrom()","recvfrom()","recvfrom()","recvfrom_nonblock()","recvfrom_nonblock()","recvmsg()","recvmsg_nonblock()","remote_address()","reply()","resolve_hostname()","resolved?()","resolved_all_families?()","resolved_successfully?()","reverse_each_name()","reverse_each_name_with_prefix_optional()","second_to_timeout()","send()","send()","send_io()","sendmsg()","sendmsg_nonblock()","setsockopt()","shutdown()","sockaddr_in()","sockaddr_un()","socketpair()","socketpair()","socktype()","sysaccept()","sysaccept()","sysaccept()","tcp()","tcp()","tcp_fast_fallback()","tcp_fast_fallback=()","tcp_server_loop()","tcp_server_sockets()","tcp_with_fast_fallback()","tcp_without_fast_fallback()","timestamp()","to_s()","to_s()","to_sockaddr()","type()","udp()","udp_server_loop()","udp_server_loop_on()","udp_server_recv()","udp_server_sockets()","unix()","unix()","unix?()","unix_path()","unix_rights()","unix_rights()","unix_server_loop()","unix_server_socket()","unix_socket_abstract_name?()","unpack()","unpack_sockaddr_in()","unpack_sockaddr_un()","vhid()"],"longSearchIndex":["addrinfo","basicsocket","ipsocket","object","sockssocket","socket","socket::ancillarydata","socket::constants","socket::hostnameresolutionresult","socket::hostnameresolutionstore","socket::ifaddr","socket::option","socket::resolutionerror","socket::udpsource","socketerror","tcpserver","tcpsocket","udpsocket","unixserver","unixsocket","socket#accept()","tcpserver#accept()","unixserver#accept()","socket::accept_loop()","socket#accept_nonblock()","tcpserver#accept_nonblock()","unixserver#accept_nonblock()","socket::hostnameresolutionresult#add()","socket::hostnameresolutionstore#add_error()","socket::hostnameresolutionstore#add_resolved()","ipsocket#addr()","socket::ifaddr#addr()","unixsocket#addr()","addrinfo#afamily()","socket::hostnameresolutionstore#any_addrinfos?()","socket::hostnameresolutionstore#any_unresolved_family?()","addrinfo#bind()","socket#bind()","udpsocket#bind()","socket::option::bool()","socket::option#bool()","socket::ifaddr#broadaddr()","socket::option::byte()","socket::option#byte()","object#c_str()","addrinfo#canonname()","sockssocket#close()","socket::hostnameresolutionresult#close()","basicsocket#close_read()","basicsocket#close_write()","socket::ancillarydata#cmsg_is?()","addrinfo#connect()","socket#connect()","udpsocket#connect()","basicsocket#connect_address()","addrinfo#connect_from()","addrinfo#connect_internal()","socket#connect_nonblock()","addrinfo#connect_to()","socket::current_clock_time()","socket::ancillarydata#data()","socket::option#data()","object#def_intern()","object#def_name_to_int()","basicsocket::do_not_reverse_lookup()","basicsocket#do_not_reverse_lookup()","basicsocket::do_not_reverse_lookup=()","basicsocket#do_not_reverse_lookup=()","socket::ifaddr#dstaddr()","object#each_const()","object#each_name()","object#each_names_with_len()","socket::hostnameresolutionstore#empty_addrinfos?()","socket::resolutionerror#error_code()","socket::expired?()","socket::ancillarydata#family()","socket::option#family()","addrinfo#family_addrinfo()","socket::ifaddr#flags()","basicsocket::for_fd()","addrinfo::foreach()","socket::hostnameresolutionresult#get()","socket::hostnameresolutionstore#get_addrinfo()","ipsocket::getaddress()","addrinfo::getaddrinfo()","socket::getaddrinfo()","socket::gethostbyaddr()","socket::gethostbyname()","tcpsocket::gethostbyname()","socket::gethostname()","socket::getifaddrs()","addrinfo#getnameinfo()","socket::getnameinfo()","basicsocket#getpeereid()","basicsocket#getpeername()","socket::getservbyname()","socket::getservbyport()","basicsocket#getsockname()","basicsocket#getsockopt()","socket::ifaddr#ifindex()","addrinfo#inspect()","ipsocket#inspect()","socket::ancillarydata#inspect()","socket::ifaddr#inspect()","socket::option#inspect()","addrinfo#inspect_sockaddr()","socket::ancillarydata::int()","socket::ancillarydata#int()","socket::option::int()","socket::option#int()","addrinfo::ip()","addrinfo#ip?()","addrinfo#ip_address()","socket::ip_address?()","socket::ip_address_list()","socket::ancillarydata::ip_pktinfo()","socket::ancillarydata#ip_pktinfo()","addrinfo#ip_port()","addrinfo#ip_unpack()","addrinfo#ipv4?()","addrinfo#ipv4_loopback?()","addrinfo#ipv4_multicast?()","socket::option::ipv4_multicast_loop()","socket::option#ipv4_multicast_loop()","socket::option::ipv4_multicast_ttl()","socket::option#ipv4_multicast_ttl()","addrinfo#ipv4_private?()","addrinfo#ipv6?()","addrinfo#ipv6_linklocal?()","addrinfo#ipv6_loopback?()","addrinfo#ipv6_mc_global?()","addrinfo#ipv6_mc_linklocal?()","addrinfo#ipv6_mc_nodelocal?()","addrinfo#ipv6_mc_orglocal?()","addrinfo#ipv6_mc_sitelocal?()","addrinfo#ipv6_multicast?()","socket::ancillarydata::ipv6_pktinfo()","socket::ancillarydata#ipv6_pktinfo()","socket::ancillarydata#ipv6_pktinfo_addr()","socket::ancillarydata#ipv6_pktinfo_ifindex()","addrinfo#ipv6_sitelocal?()","addrinfo#ipv6_to_ipv4()","addrinfo#ipv6_unique_local?()","addrinfo#ipv6_unspecified?()","addrinfo#ipv6_v4compat?()","addrinfo#ipv6_v4mapped?()","socket#ipv6only!()","socket::ancillarydata#level()","socket::option#level()","socket::option::linger()","socket::option#linger()","addrinfo#listen()","socket#listen()","tcpserver#listen()","unixserver#listen()","basicsocket#local_address()","socket::ifaddr#name()","socket::ifaddr#netmask()","addrinfo::new()","sockssocket::new()","socket::new()","socket::ancillarydata::new()","socket::hostnameresolutionresult::new()","socket::hostnameresolutionstore::new()","socket::option::new()","socket::udpsource::new()","tcpserver::new()","tcpsocket::new()","udpsocket::new()","unixserver::new()","unixsocket::new()","socket::hostnameresolutionresult#notifier()","socket::option#optname()","socket::pack_sockaddr_in()","socket::pack_sockaddr_un()","socket::pair()","unixsocket::pair()","unixsocket#path()","ipsocket#peeraddr()","unixsocket#peeraddr()","addrinfo#pfamily()","addrinfo#protocol()","basicsocket#recv()","unixsocket#recv_io()","basicsocket#recv_nonblock()","ipsocket#recvfrom()","socket#recvfrom()","unixsocket#recvfrom()","socket#recvfrom_nonblock()","udpsocket#recvfrom_nonblock()","basicsocket#recvmsg()","basicsocket#recvmsg_nonblock()","basicsocket#remote_address()","socket::udpsource#reply()","socket::resolve_hostname()","socket::hostnameresolutionstore#resolved?()","socket::hostnameresolutionstore#resolved_all_families?()","socket::hostnameresolutionstore#resolved_successfully?()","object#reverse_each_name()","object#reverse_each_name_with_prefix_optional()","socket::second_to_timeout()","basicsocket#send()","udpsocket#send()","unixsocket#send_io()","basicsocket#sendmsg()","basicsocket#sendmsg_nonblock()","basicsocket#setsockopt()","basicsocket#shutdown()","socket::sockaddr_in()","socket::sockaddr_un()","socket::socketpair()","unixsocket::socketpair()","addrinfo#socktype()","socket#sysaccept()","tcpserver#sysaccept()","unixserver#sysaccept()","addrinfo::tcp()","socket::tcp()","socket::tcp_fast_fallback()","socket::tcp_fast_fallback=()","socket::tcp_server_loop()","socket::tcp_server_sockets()","socket::tcp_with_fast_fallback()","socket::tcp_without_fast_fallback()","socket::ancillarydata#timestamp()","addrinfo#to_s()","socket::option#to_s()","addrinfo#to_sockaddr()","socket::ancillarydata#type()","addrinfo::udp()","socket::udp_server_loop()","socket::udp_server_loop_on()","socket::udp_server_recv()","socket::udp_server_sockets()","addrinfo::unix()","socket::unix()","addrinfo#unix?()","addrinfo#unix_path()","socket::ancillarydata::unix_rights()","socket::ancillarydata#unix_rights()","socket::unix_server_loop()","socket::unix_server_socket()","socket::unix_socket_abstract_name?()","socket::option#unpack()","socket::unpack_sockaddr_in()","socket::unpack_sockaddr_un()","socket::ifaddr#vhid()"],"info":[["Addrinfo","","Addrinfo.html","","<p>The Addrinfo class maps <code>struct addrinfo</code> to ruby.  This structure identifies an Internet host and a service. …\n"],["BasicSocket","","BasicSocket.html","","<p>BasicSocket is the super class for all the Socket classes.\n"],["IPSocket","","IPSocket.html","","<p>IPSocket is the super class of TCPSocket and UDPSocket.\n"],["Object","","Object.html","",""],["SOCKSSocket","","SOCKSSocket.html","","<p>SOCKS is an Internet protocol that routes packets between a client and a server through a proxy server. …\n"],["Socket","","Socket.html","","<p>Class <code>Socket</code> provides access to the underlying operating system socket implementations.  It can be used …\n"],["Socket::AncillaryData","","Socket/AncillaryData.html","","<p>Socket::AncillaryData represents the ancillary data (control information) used by sendmsg and recvmsg …\n"],["Socket::Constants","","Socket/Constants.html","","<p>Socket::Constants provides socket-related constants.  All possible socket constants are listed in the …\n"],["Socket::HostnameResolutionResult","","Socket/HostnameResolutionResult.html","",""],["Socket::HostnameResolutionStore","","Socket/HostnameResolutionStore.html","",""],["Socket::Ifaddr","","Socket/Ifaddr.html","","<p>Socket::Ifaddr represents a result of getifaddrs() function.\n"],["Socket::Option","","Socket/Option.html","","<p>Socket::Option represents a socket option used by BasicSocket#getsockopt and BasicSocket#setsockopt. …\n"],["Socket::ResolutionError","","Socket/ResolutionError.html","","<p>Socket::ResolutionError is the error class for hostname resolution.\n"],["Socket::UDPSource","","Socket/UDPSource.html","","<p>UDP/IP address information used by Socket.udp_server_loop.\n"],["SocketError","","SocketError.html","","<p>SocketError is the error class for socket.\n"],["TCPServer","","TCPServer.html","","<p>TCPServer represents a TCP/IP server socket.\n<p>A simple TCP server may look like:\n\n<pre class=\"ruby\"><span class=\"ruby-identifier\">require</span> <span class=\"ruby-string\">&#39;socket&#39;</span>\n\n<span class=\"ruby-identifier\">server</span> <span class=\"ruby-operator\">...</span>\n</pre>\n"],["TCPSocket","","TCPSocket.html","","<p>TCPSocket represents a TCP/IP client socket.\n<p>A simple client may look like:\n\n<pre class=\"ruby\"><span class=\"ruby-identifier\">require</span> <span class=\"ruby-string\">&#39;socket&#39;</span>\n\n<span class=\"ruby-identifier\">s</span> = <span class=\"ruby-constant\">TCPSocket</span>.<span class=\"ruby-identifier\">new</span> <span class=\"ruby-operator\">...</span>\n</pre>\n"],["UDPSocket","","UDPSocket.html","","<p>UDPSocket represents a UDP/IP socket.\n"],["UNIXServer","","UNIXServer.html","","<p>UNIXServer represents a UNIX domain stream server socket.\n"],["UNIXSocket","","UNIXSocket.html","","<p>UNIXSocket represents a UNIX domain stream client socket.\n"],["accept","Socket","Socket.html#method-i-accept","()","<p>Accepts a next connection. Returns a new Socket object and Addrinfo object.\n\n<pre>serv = Socket.new(:INET, :STREAM, ...</pre>\n"],["accept","TCPServer","TCPServer.html#method-i-accept","()","<p>Accepts an incoming connection. It returns a new TCPSocket object.\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">TCPServer</span>.<span class=\"ruby-identifier\">open</span>(<span class=\"ruby-string\">&quot;127.0.0.1&quot;</span>, <span class=\"ruby-value\">14641</span>) <span class=\"ruby-operator\">...</span>\n</pre>\n"],["accept","UNIXServer","UNIXServer.html#method-i-accept","()","<p>Accepts an incoming connection. It returns a new UNIXSocket object.\n\n<pre>UNIXServer.open(&quot;/tmp/sock&quot;) {|serv| ...</pre>\n"],["accept_loop","Socket","Socket.html#method-c-accept_loop","(*sockets)","<p>yield socket and client address for each a connection accepted via given sockets.\n<p>The arguments are a …\n"],["accept_nonblock","Socket","Socket.html#method-i-accept_nonblock","(exception: true)","<p>Accepts an incoming connection using accept(2) after O_NONBLOCK is set for the underlying file descriptor. …\n"],["accept_nonblock","TCPServer","TCPServer.html#method-i-accept_nonblock","(exception: true)","<p>Accepts an incoming connection using accept(2) after O_NONBLOCK is set for the underlying file descriptor. …\n"],["accept_nonblock","UNIXServer","UNIXServer.html#method-i-accept_nonblock","(exception: true)","<p>Accepts an incoming connection using accept(2) after O_NONBLOCK is set for the underlying file descriptor. …\n"],["add","Socket::HostnameResolutionResult","Socket/HostnameResolutionResult.html#method-i-add","(family, result)",""],["add_error","Socket::HostnameResolutionStore","Socket/HostnameResolutionStore.html#method-i-add_error","(family_name, error)",""],["add_resolved","Socket::HostnameResolutionStore","Socket/HostnameResolutionStore.html#method-i-add_resolved","(family_name, addrinfos)",""],["addr","IPSocket","IPSocket.html#method-i-addr","(*args)","<p>Returns the local address as an array which contains address_family, port, hostname and numeric_address. …\n"],["addr","Socket::Ifaddr","Socket/Ifaddr.html#method-i-addr","()","<p>Returns the address of <em>ifaddr</em>. nil is returned if address is not available in <em>ifaddr</em>.\n"],["addr","UNIXSocket","UNIXSocket.html#method-i-addr","()","<p>Returns the local address as an array which contains address_family and unix_path.\n<p>Example\n\n<pre class=\"ruby\"><span class=\"ruby-identifier\">serv</span> = <span class=\"ruby-constant\">UNIXServer</span>.<span class=\"ruby-identifier\">new</span>(<span class=\"ruby-string\">&quot;/tmp/sock&quot;</span>) <span class=\"ruby-operator\">...</span>\n</pre>\n"],["afamily","Addrinfo","Addrinfo.html#method-i-afamily","()","<p>returns the address family as an integer.\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">Addrinfo</span>.<span class=\"ruby-identifier\">tcp</span>(<span class=\"ruby-string\">&quot;localhost&quot;</span>, <span class=\"ruby-value\">80</span>).<span class=\"ruby-identifier\">afamily</span> <span class=\"ruby-operator\">==</span> <span class=\"ruby-constant\">Socket</span><span class=\"ruby-operator\">::</span><span class=\"ruby-constant\">AF_INET</span> <span class=\"ruby-comment\">#=&gt; ...</span>\n</pre>\n"],["any_addrinfos?","Socket::HostnameResolutionStore","Socket/HostnameResolutionStore.html#method-i-any_addrinfos-3F","()",""],["any_unresolved_family?","Socket::HostnameResolutionStore","Socket/HostnameResolutionStore.html#method-i-any_unresolved_family-3F","()",""],["bind","Addrinfo","Addrinfo.html#method-i-bind","()","<p>creates a socket bound to self.\n<p>If a block is given, it is called with the socket and the value of the …\n"],["bind","Socket","Socket.html#method-i-bind","(p1)","<p>Binds to the given local address.\n<p>Parameter\n<p><code>local_sockaddr</code> - the <code>struct</code> sockaddr contained in a string …\n"],["bind","UDPSocket","UDPSocket.html#method-i-bind","(p1, p2)","<p>Binds <em>udpsocket</em> to <em>host</em>:<em>port</em>.\n\n<pre>u1 = UDPSocket.new\nu1.bind(&quot;127.0.0.1&quot;, 4913)\nu1.send &quot;message-to-self&quot;, ...</pre>\n"],["bool","Socket::Option","Socket/Option.html#method-c-bool","(p1, p2, p3, p4)","<p>Creates a new Socket::Option object which contains boolean as data. Actually 0 or 1 as int is used.\n\n<pre class=\"ruby\"><span class=\"ruby-identifier\">require</span> <span class=\"ruby-operator\">...</span>\n</pre>\n"],["bool","Socket::Option","Socket/Option.html#method-i-bool","()","<p>Returns the data in <em>sockopt</em> as an boolean value.\n\n<pre>sockopt = Socket::Option.int(:INET, :SOCKET, :KEEPALIVE, ...</pre>\n"],["broadaddr","Socket::Ifaddr","Socket/Ifaddr.html#method-i-broadaddr","()","<p>Returns the broadcast address of <em>ifaddr</em>. nil is returned if the flags doesn’t have IFF_BROADCAST …\n"],["byte","Socket::Option","Socket/Option.html#method-c-byte","(p1, p2, p3, p4)","<p>Creates a new Socket::Option object which contains a byte as data.\n\n<pre>p Socket::Option.byte(:INET, :SOCKET, ...</pre>\n"],["byte","Socket::Option","Socket/Option.html#method-i-byte","()","<p>Returns the data in <em>sockopt</em> as an byte.\n\n<pre class=\"ruby\"><span class=\"ruby-identifier\">sockopt</span> = <span class=\"ruby-constant\">Socket</span><span class=\"ruby-operator\">::</span><span class=\"ruby-constant\">Option</span>.<span class=\"ruby-identifier\">byte</span>(<span class=\"ruby-value\">:INET</span>, <span class=\"ruby-value\">:SOCKET</span>, <span class=\"ruby-value\">:KEEPALIVE</span>, <span class=\"ruby-value\">1</span>)\n<span class=\"ruby-identifier\">p</span> <span class=\"ruby-operator\">...</span>\n</pre>\n"],["c_str","Object","Object.html#method-i-c_str","(str)",""],["canonname","Addrinfo","Addrinfo.html#method-i-canonname","()","<p>returns the canonical name as a string.\n<p>nil is returned if no canonical name.\n<p>The canonical name is set …\n"],["close","SOCKSSocket","SOCKSSocket.html#method-i-close","()","<p>Closes the SOCKS connection.\n"],["close","Socket::HostnameResolutionResult","Socket/HostnameResolutionResult.html#method-i-close","()",""],["close_read","BasicSocket","BasicSocket.html#method-i-close_read","()","<p>Disallows further read using shutdown system call.\n\n<pre class=\"ruby\"><span class=\"ruby-identifier\">s1</span>, <span class=\"ruby-identifier\">s2</span> = <span class=\"ruby-constant\">UNIXSocket</span>.<span class=\"ruby-identifier\">pair</span>\n<span class=\"ruby-identifier\">s1</span>.<span class=\"ruby-identifier\">close_read</span>\n<span class=\"ruby-identifier\">s2</span>.<span class=\"ruby-identifier\">puts</span> <span class=\"ruby-comment\">#=&gt; ...</span>\n</pre>\n"],["close_write","BasicSocket","BasicSocket.html#method-i-close_write","()","<p>Disallows further write using shutdown system call.\n\n<pre>UNIXSocket.pair {|s1, s2|\n  s1.print &quot;ping&quot;\n  s1.close_write ...</pre>\n"],["cmsg_is?","Socket::AncillaryData","Socket/AncillaryData.html#method-i-cmsg_is-3F","(p1, p2)","<p>tests the level and type of <em>ancillarydata</em>.\n\n<pre>ancdata = Socket::AncillaryData.new(:INET6, :IPV6, :PKTINFO, ...</pre>\n"],["connect","Addrinfo","Addrinfo.html#method-i-connect","(timeout: nil, &block)","<p>creates a socket connected to the address of self.\n<p>The optional argument <em>opts</em> is options represented by …\n"],["connect","Socket","Socket.html#method-i-connect","(p1)","<p>Requests a connection to be made on the given <code>remote_sockaddr</code>. Returns 0 if successful, otherwise an …\n"],["connect","UDPSocket","UDPSocket.html#method-i-connect","(p1, p2)","<p>Connects <em>udpsocket</em> to <em>host</em>:<em>port</em>.\n<p>This makes possible to send without destination address.\n\n<pre class=\"ruby\"><span class=\"ruby-identifier\">u1</span> = <span class=\"ruby-constant\">UDPSocket</span>.<span class=\"ruby-identifier\">new</span> <span class=\"ruby-operator\">...</span>\n</pre>\n"],["connect_address","BasicSocket","BasicSocket.html#method-i-connect_address","()","<p>Returns an address of the socket suitable for connect in the local machine.\n<p>This method returns <em>self</em>.local_address, …\n"],["connect_from","Addrinfo","Addrinfo.html#method-i-connect_from","(*args, timeout: nil, &block)","<p>creates a socket connected to the address of self.\n<p>If one or more arguments given as <em>local_addr_args</em>, …\n"],["connect_internal","Addrinfo","Addrinfo.html#method-i-connect_internal","(local_addrinfo, timeout=nil)","<p>creates a new Socket connected to the address of <code>local_addrinfo</code>.\n<p>If <em>local_addrinfo</em> is nil, the address …\n"],["connect_nonblock","Socket","Socket.html#method-i-connect_nonblock","(addr, exception: true)","<p>Requests a connection to be made on the given <code>remote_sockaddr</code> after O_NONBLOCK is set for the underlying …\n"],["connect_to","Addrinfo","Addrinfo.html#method-i-connect_to","(*args, timeout: nil, &block)","<p>creates a socket connected to <em>remote_addr_args</em> and bound to self.\n<p>The optional last argument <em>opts</em> is options …\n"],["current_clock_time","Socket","Socket.html#method-c-current_clock_time","()",""],["data","Socket::AncillaryData","Socket/AncillaryData.html#method-i-data","()","<p>returns the cmsg data as a string.\n\n<pre class=\"ruby\"><span class=\"ruby-identifier\">p</span> <span class=\"ruby-constant\">Socket</span><span class=\"ruby-operator\">::</span><span class=\"ruby-constant\">AncillaryData</span>.<span class=\"ruby-identifier\">new</span>(<span class=\"ruby-value\">:INET6</span>, <span class=\"ruby-value\">:IPV6</span>, <span class=\"ruby-value\">:PKTINFO</span>, <span class=\"ruby-string\">&quot;&quot;</span>).<span class=\"ruby-identifier\">data</span>\n<span class=\"ruby-comment\">#=&gt; &quot;&quot;</span>\n</pre>\n"],["data","Socket::Option","Socket/Option.html#method-i-data","()","<p>returns the socket option data as a string.\n\n<pre class=\"ruby\"><span class=\"ruby-identifier\">p</span> <span class=\"ruby-constant\">Socket</span><span class=\"ruby-operator\">::</span><span class=\"ruby-constant\">Option</span>.<span class=\"ruby-identifier\">new</span>(<span class=\"ruby-value\">:INET6</span>, <span class=\"ruby-value\">:IPV6</span>, <span class=\"ruby-value\">:RECVPKTINFO</span>, [<span class=\"ruby-value\">1</span>].<span class=\"ruby-identifier\">pack</span>(<span class=\"ruby-string\">&quot;i!&quot;</span>)).<span class=\"ruby-identifier\">data</span> <span class=\"ruby-operator\">...</span>\n</pre>\n"],["def_intern","Object","Object.html#method-i-def_intern","(func_name, pat, prefix_optional=nil)",""],["def_name_to_int","Object","Object.html#method-i-def_name_to_int","(funcname, pat, prefix_optional, guard=nil)",""],["do_not_reverse_lookup","BasicSocket","BasicSocket.html#method-c-do_not_reverse_lookup","()","<p>Gets the global do_not_reverse_lookup flag.\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">BasicSocket</span>.<span class=\"ruby-identifier\">do_not_reverse_lookup</span>  <span class=\"ruby-comment\">#=&gt; false</span>\n</pre>\n"],["do_not_reverse_lookup","BasicSocket","BasicSocket.html#method-i-do_not_reverse_lookup","()","<p>Gets the do_not_reverse_lookup flag of <em>basicsocket</em>.\n\n<pre class=\"ruby\"><span class=\"ruby-identifier\">require</span> <span class=\"ruby-string\">&#39;socket&#39;</span>\n\n<span class=\"ruby-constant\">BasicSocket</span>.<span class=\"ruby-identifier\">do_not_reverse_lookup</span> <span class=\"ruby-operator\">...</span>\n</pre>\n"],["do_not_reverse_lookup=","BasicSocket","BasicSocket.html#method-c-do_not_reverse_lookup-3D","(p1)","<p>Sets the global do_not_reverse_lookup flag.\n<p>The flag is used for initial value of do_not_reverse_lookup …\n"],["do_not_reverse_lookup=","BasicSocket","BasicSocket.html#method-i-do_not_reverse_lookup-3D","(p1)","<p>Sets the do_not_reverse_lookup flag of <em>basicsocket</em>.\n\n<pre>TCPSocket.open(&quot;www.ruby-lang.org&quot;, 80) {|sock|\n  ...</pre>\n"],["dstaddr","Socket::Ifaddr","Socket/Ifaddr.html#method-i-dstaddr","()","<p>Returns the destination address of <em>ifaddr</em>. nil is returned if the flags doesn’t have IFF_POINTOPOINT …\n"],["each_const","Object","Object.html#method-i-each_const","()",""],["each_name","Object","Object.html#method-i-each_name","(pat)",""],["each_names_with_len","Object","Object.html#method-i-each_names_with_len","(pat, prefix_optional=nil)",""],["empty_addrinfos?","Socket::HostnameResolutionStore","Socket/HostnameResolutionStore.html#method-i-empty_addrinfos-3F","()",""],["error_code","Socket::ResolutionError","Socket/ResolutionError.html#method-i-error_code","()","<p>Returns the raw error code indicating the cause of the hostname resolution failure.\n\n<pre>begin\n  Addrinfo.getaddrinfo(&quot;ruby-lang.org&quot;, ...</pre>\n"],["expired?","Socket","Socket.html#method-c-expired-3F","(started_at, ends_at)",""],["family","Socket::AncillaryData","Socket/AncillaryData.html#method-i-family","()","<p>returns the socket family as an integer.\n\n<pre class=\"ruby\"><span class=\"ruby-identifier\">p</span> <span class=\"ruby-constant\">Socket</span><span class=\"ruby-operator\">::</span><span class=\"ruby-constant\">AncillaryData</span>.<span class=\"ruby-identifier\">new</span>(<span class=\"ruby-value\">:INET6</span>, <span class=\"ruby-value\">:IPV6</span>, <span class=\"ruby-value\">:PKTINFO</span>, <span class=\"ruby-string\">&quot;&quot;</span>).<span class=\"ruby-identifier\">family</span> <span class=\"ruby-operator\">...</span>\n</pre>\n"],["family","Socket::Option","Socket/Option.html#method-i-family","()","<p>returns the socket family as an integer.\n\n<pre class=\"ruby\"><span class=\"ruby-identifier\">p</span> <span class=\"ruby-constant\">Socket</span><span class=\"ruby-operator\">::</span><span class=\"ruby-constant\">Option</span>.<span class=\"ruby-identifier\">new</span>(<span class=\"ruby-value\">:INET6</span>, <span class=\"ruby-value\">:IPV6</span>, <span class=\"ruby-value\">:RECVPKTINFO</span>, [<span class=\"ruby-value\">1</span>].<span class=\"ruby-identifier\">pack</span>(<span class=\"ruby-string\">&quot;i!&quot;</span>)).<span class=\"ruby-identifier\">family</span> <span class=\"ruby-operator\">...</span>\n</pre>\n"],["family_addrinfo","Addrinfo","Addrinfo.html#method-i-family_addrinfo","(*args)","<p>creates an Addrinfo object from the arguments.\n<p>The arguments are interpreted as similar to self.\n\n<pre>Addrinfo.tcp(&quot;0.0.0.0&quot;, ...</pre>\n"],["flags","Socket::Ifaddr","Socket/Ifaddr.html#method-i-flags","()","<p>Returns the flags of <em>ifaddr</em>.\n"],["for_fd","BasicSocket","BasicSocket.html#method-c-for_fd","(p1)","<p>Returns a socket object which contains the file descriptor, <em>fd</em>.\n\n<pre class=\"ruby\"><span class=\"ruby-comment\"># If invoked by inetd, STDIN/STDOUT/STDERR ...</span>\n</pre>\n"],["foreach","Addrinfo","Addrinfo.html#method-c-foreach","(nodename, service, family=nil, socktype=nil, protocol=nil, flags=nil, timeout: nil, &block)","<p>iterates over the list of Addrinfo objects obtained by Addrinfo.getaddrinfo.\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">Addrinfo</span>.<span class=\"ruby-identifier\">foreach</span>(<span class=\"ruby-keyword\">nil</span>, <span class=\"ruby-value\">80</span>) <span class=\"ruby-operator\">...</span>\n</pre>\n"],["get","Socket::HostnameResolutionResult","Socket/HostnameResolutionResult.html#method-i-get","()",""],["get_addrinfo","Socket::HostnameResolutionStore","Socket/HostnameResolutionStore.html#method-i-get_addrinfo","()",""],["getaddress","IPSocket","IPSocket.html#method-c-getaddress","(p1)","<p>Lookups the IP address of <em>host</em>.\n\n<pre class=\"ruby\"><span class=\"ruby-identifier\">require</span> <span class=\"ruby-string\">&#39;socket&#39;</span>\n\n<span class=\"ruby-constant\">IPSocket</span>.<span class=\"ruby-identifier\">getaddress</span>(<span class=\"ruby-string\">&quot;localhost&quot;</span>)     <span class=\"ruby-comment\">#=&gt; &quot;127.0.0.1&quot; ...</span>\n</pre>\n"],["getaddrinfo","Addrinfo","Addrinfo.html#method-c-getaddrinfo","(p1, p2, p3 = v3, p4 = v4, p5 = v5, p6 = v6, p7 = {})","<p>returns a list of addrinfo objects as an array.\n<p>This method converts nodename (hostname) and service (port) …\n"],["getaddrinfo","Socket","Socket.html#method-c-getaddrinfo","(p1, p2, p3 = v3, p4 = v4, p5 = v5, p6 = v6, p7 = v7)","<p>Obtains address information for <em>nodename</em>:<em>servname</em>.\n<p>Note that Addrinfo.getaddrinfo provides the same functionality …\n"],["gethostbyaddr","Socket","Socket.html#method-c-gethostbyaddr","(p1, p2 = v2)","<p>Use Addrinfo#getnameinfo instead. This method is deprecated for the following reasons:\n<p>Uncommon address …\n"],["gethostbyname","Socket","Socket.html#method-c-gethostbyname","(p1)","<p>Use Addrinfo.getaddrinfo instead. This method is deprecated for the following reasons:\n<p>The 3rd element …\n"],["gethostbyname","TCPSocket","TCPSocket.html#method-c-gethostbyname","(p1)","<p>Use Addrinfo.getaddrinfo instead. This method is deprecated for the following reasons:\n<p>The 3rd element …\n"],["gethostname","Socket","Socket.html#method-c-gethostname","()","<p>Returns the hostname.\n\n<pre class=\"ruby\"><span class=\"ruby-identifier\">p</span> <span class=\"ruby-constant\">Socket</span>.<span class=\"ruby-identifier\">gethostname</span> <span class=\"ruby-comment\">#=&gt; &quot;hal&quot;</span>\n</pre>\n<p>Note that it is not guaranteed to be able to convert …\n"],["getifaddrs","Socket","Socket.html#method-c-getifaddrs","()","<p>Returns an array of interface addresses. An element of the array is an instance of Socket::Ifaddr.\n<p>This …\n"],["getnameinfo","Addrinfo","Addrinfo.html#method-i-getnameinfo","(p1 = v1)","<p>returns nodename and service as a pair of strings. This converts struct sockaddr in addrinfo to textual …\n"],["getnameinfo","Socket","Socket.html#method-c-getnameinfo","(p1, p2 = v2)","<p>Obtains name information for <em>sockaddr</em>.\n<p><em>sockaddr</em> should be one of follows.\n<p>packed sockaddr string such as …\n"],["getpeereid","BasicSocket","BasicSocket.html#method-i-getpeereid","()","<p>Returns the user and group on the peer of the UNIX socket. The result is a two element array which contains …\n"],["getpeername","BasicSocket","BasicSocket.html#method-i-getpeername","()","<p>Returns the remote address of the socket as a sockaddr string.\n\n<pre>TCPServer.open(&quot;127.0.0.1&quot;, 1440) {|serv| ...</pre>\n"],["getservbyname","Socket","Socket.html#method-c-getservbyname","(p1, p2 = v2)","<p>Obtains the port number for <em>service_name</em>.\n<p>If <em>protocol_name</em> is not given, “tcp” is assumed.\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">Socket</span>.<span class=\"ruby-identifier\">getservbyname</span>(<span class=\"ruby-string\">&quot;smtp&quot;</span>) <span class=\"ruby-operator\">...</span>\n</pre>\n"],["getservbyport","Socket","Socket.html#method-c-getservbyport","(p1, p2 = v2)","<p>Obtains the port number for <em>port</em>.\n<p>If <em>protocol_name</em> is not given, “tcp” is assumed.\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">Socket</span>.<span class=\"ruby-identifier\">getservbyport</span>(<span class=\"ruby-value\">80</span>) <span class=\"ruby-operator\">...</span>\n</pre>\n"],["getsockname","BasicSocket","BasicSocket.html#method-i-getsockname","()","<p>Returns the local address of the socket as a sockaddr string.\n\n<pre>TCPServer.open(&quot;127.0.0.1&quot;, 15120) {|serv| ...</pre>\n"],["getsockopt","BasicSocket","BasicSocket.html#method-i-getsockopt","(p1, p2)","<p>Gets a socket option. These are protocol and system specific, see your local system documentation for …\n"],["ifindex","Socket::Ifaddr","Socket/Ifaddr.html#method-i-ifindex","()","<p>Returns the interface index of <em>ifaddr</em>.\n"],["inspect","Addrinfo","Addrinfo.html#method-i-inspect","()","<p>returns a string which shows addrinfo in human-readable form.\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">Addrinfo</span>.<span class=\"ruby-identifier\">tcp</span>(<span class=\"ruby-string\">&quot;localhost&quot;</span>, <span class=\"ruby-value\">80</span>).<span class=\"ruby-identifier\">inspect</span> <span class=\"ruby-comment\">#=&gt; ...</span>\n</pre>\n"],["inspect","IPSocket","IPSocket.html#method-i-inspect","()","<p>Return a string describing this IPSocket object.\n"],["inspect","Socket::AncillaryData","Socket/AncillaryData.html#method-i-inspect","()","<p>returns a string which shows ancillarydata in human-readable form.\n\n<pre>p Socket::AncillaryData.new(:INET6, ...</pre>\n"],["inspect","Socket::Ifaddr","Socket/Ifaddr.html#method-i-inspect","()","<p>Returns a string to show contents of <em>ifaddr</em>.\n"],["inspect","Socket::Option","Socket/Option.html#method-i-inspect","()","<p>Returns a string which shows sockopt in human-readable form.\n\n<pre>p Socket::Option.new(:INET, :SOCKET, :KEEPALIVE, ...</pre>\n"],["inspect_sockaddr","Addrinfo","Addrinfo.html#method-i-inspect_sockaddr","()","<p>returns a string which shows the sockaddr in <em>addrinfo</em> with human-readable form.\n\n<pre>Addrinfo.tcp(&quot;localhost&quot;, ...</pre>\n"],["int","Socket::AncillaryData","Socket/AncillaryData.html#method-c-int","(p1, p2, p3, p4)","<p>Creates a new Socket::AncillaryData object which contains a int as data.\n<p>The size and endian is dependent …\n"],["int","Socket::AncillaryData","Socket/AncillaryData.html#method-i-int","()","<p>Returns the data in <em>ancillarydata</em> as an int.\n<p>The size and endian is dependent on the host.\n\n<pre>ancdata = Socket::AncillaryData.int(:UNIX, ...</pre>\n"],["int","Socket::Option","Socket/Option.html#method-c-int","(p1, p2, p3, p4)","<p>Creates a new Socket::Option object which contains an int as data.\n<p>The size and endian is dependent on …\n"],["int","Socket::Option","Socket/Option.html#method-i-int","()","<p>Returns the data in <em>sockopt</em> as an int.\n<p>The size and endian is dependent on the platform.\n\n<pre>sockopt = Socket::Option.int(:INET, ...</pre>\n"],["ip","Addrinfo","Addrinfo.html#method-c-ip","(p1)","<p>returns an addrinfo object for IP address.\n<p>The port, socktype, protocol of the result is filled by zero. …\n"],["ip?","Addrinfo","Addrinfo.html#method-i-ip-3F","()","<p>returns true if addrinfo is internet (IPv4/IPv6) address. returns false otherwise.\n\n<pre>Addrinfo.tcp(&quot;127.0.0.1&quot;, ...</pre>\n"],["ip_address","Addrinfo","Addrinfo.html#method-i-ip_address","()","<p>Returns the IP address as a string.\n\n<pre>Addrinfo.tcp(&quot;127.0.0.1&quot;, 80).ip_address    #=&gt; &quot;127.0.0.1&quot;\nAddrinfo.tcp(&quot;::1&quot;, ...</pre>\n"],["ip_address?","Socket","Socket.html#method-c-ip_address-3F","(hostname)",""],["ip_address_list","Socket","Socket.html#method-c-ip_address_list","()","<p>Returns local IP addresses as an array.\n<p>The array contains Addrinfo objects.\n\n<pre class=\"ruby\"><span class=\"ruby-identifier\">pp</span> <span class=\"ruby-constant\">Socket</span>.<span class=\"ruby-identifier\">ip_address_list</span> <span class=\"ruby-operator\">...</span>\n</pre>\n"],["ip_pktinfo","Socket::AncillaryData","Socket/AncillaryData.html#method-c-ip_pktinfo","(p1, p2, p3 = v3)","<p>Returns new ancillary data for IP_PKTINFO.\n<p>If spec_dst is not given, addr is used.\n<p>IP_PKTINFO is not standard. …\n"],["ip_pktinfo","Socket::AncillaryData","Socket/AncillaryData.html#method-i-ip_pktinfo","()","<p>Extracts addr, ifindex and spec_dst from IP_PKTINFO ancillary data.\n<p>IP_PKTINFO is not standard.\n<p>Supported …\n"],["ip_port","Addrinfo","Addrinfo.html#method-i-ip_port","()","<p>Returns the port number as an integer.\n\n<pre>Addrinfo.tcp(&quot;127.0.0.1&quot;, 80).ip_port    #=&gt; 80\nAddrinfo.tcp(&quot;::1&quot;, ...</pre>\n"],["ip_unpack","Addrinfo","Addrinfo.html#method-i-ip_unpack","()","<p>Returns the IP address and port number as 2-element array.\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">Addrinfo</span>.<span class=\"ruby-identifier\">tcp</span>(<span class=\"ruby-string\">&quot;127.0.0.1&quot;</span>, <span class=\"ruby-value\">80</span>).<span class=\"ruby-identifier\">ip_unpack</span>    <span class=\"ruby-operator\">...</span>\n</pre>\n"],["ipv4?","Addrinfo","Addrinfo.html#method-i-ipv4-3F","()","<p>returns true if addrinfo is IPv4 address. returns false otherwise.\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">Addrinfo</span>.<span class=\"ruby-identifier\">tcp</span>(<span class=\"ruby-string\">&quot;127.0.0.1&quot;</span>, <span class=\"ruby-value\">80</span>).<span class=\"ruby-identifier\">ipv4?</span> <span class=\"ruby-operator\">...</span>\n</pre>\n"],["ipv4_loopback?","Addrinfo","Addrinfo.html#method-i-ipv4_loopback-3F","()","<p>Returns true for IPv4 loopback address (127.0.0.0/8). It returns false otherwise.\n"],["ipv4_multicast?","Addrinfo","Addrinfo.html#method-i-ipv4_multicast-3F","()","<p>Returns true for IPv4 multicast address (224.0.0.0/4). It returns false otherwise.\n"],["ipv4_multicast_loop","Socket::Option","Socket/Option.html#method-c-ipv4_multicast_loop","(p1)","<p>Creates a new Socket::Option object for IP_MULTICAST_LOOP.\n<p>The size is dependent on the platform.\n\n<pre class=\"ruby\"><span class=\"ruby-identifier\">sockopt</span> <span class=\"ruby-operator\">...</span>\n</pre>\n"],["ipv4_multicast_loop","Socket::Option","Socket/Option.html#method-i-ipv4_multicast_loop","()","<p>Returns the ipv4_multicast_loop data in <em>sockopt</em> as an integer.\n\n<pre class=\"ruby\"><span class=\"ruby-identifier\">sockopt</span> = <span class=\"ruby-constant\">Socket</span><span class=\"ruby-operator\">::</span><span class=\"ruby-constant\">Option</span>.<span class=\"ruby-identifier\">ipv4_multicast_loop</span>(<span class=\"ruby-value\">10</span>) <span class=\"ruby-operator\">...</span>\n</pre>\n"],["ipv4_multicast_ttl","Socket::Option","Socket/Option.html#method-c-ipv4_multicast_ttl","(p1)","<p>Creates a new Socket::Option object for IP_MULTICAST_TTL.\n<p>The size is dependent on the platform.\n\n<pre class=\"ruby\"><span class=\"ruby-identifier\">p</span> <span class=\"ruby-constant\">Socket</span><span class=\"ruby-operator\">::</span><span class=\"ruby-constant\">Option</span>.<span class=\"ruby-identifier\">ipv4_multicast_ttl</span>(<span class=\"ruby-value\">10</span>) <span class=\"ruby-operator\">...</span>\n</pre>\n"],["ipv4_multicast_ttl","Socket::Option","Socket/Option.html#method-i-ipv4_multicast_ttl","()","<p>Returns the ipv4_multicast_ttl data in <em>sockopt</em> as an integer.\n\n<pre class=\"ruby\"><span class=\"ruby-identifier\">sockopt</span> = <span class=\"ruby-constant\">Socket</span><span class=\"ruby-operator\">::</span><span class=\"ruby-constant\">Option</span>.<span class=\"ruby-identifier\">ipv4_multicast_ttl</span>(<span class=\"ruby-value\">10</span>) <span class=\"ruby-operator\">...</span>\n</pre>\n"],["ipv4_private?","Addrinfo","Addrinfo.html#method-i-ipv4_private-3F","()","<p>Returns true for IPv4 private address (10.0.0.0/8, 172.16.0.0/12, 192.168.0.0/16). It returns false otherwise. …\n"],["ipv6?","Addrinfo","Addrinfo.html#method-i-ipv6-3F","()","<p>returns true if addrinfo is IPv6 address. returns false otherwise.\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">Addrinfo</span>.<span class=\"ruby-identifier\">tcp</span>(<span class=\"ruby-string\">&quot;127.0.0.1&quot;</span>, <span class=\"ruby-value\">80</span>).<span class=\"ruby-identifier\">ipv6?</span> <span class=\"ruby-operator\">...</span>\n</pre>\n"],["ipv6_linklocal?","Addrinfo","Addrinfo.html#method-i-ipv6_linklocal-3F","()","<p>Returns true for IPv6 link local address (fe80::/10). It returns false otherwise.\n"],["ipv6_loopback?","Addrinfo","Addrinfo.html#method-i-ipv6_loopback-3F","()","<p>Returns true for IPv6 loopback address (::1). It returns false otherwise.\n"],["ipv6_mc_global?","Addrinfo","Addrinfo.html#method-i-ipv6_mc_global-3F","()","<p>Returns true for IPv6 multicast global scope address. It returns false otherwise.\n"],["ipv6_mc_linklocal?","Addrinfo","Addrinfo.html#method-i-ipv6_mc_linklocal-3F","()","<p>Returns true for IPv6 multicast link-local scope address. It returns false otherwise.\n"],["ipv6_mc_nodelocal?","Addrinfo","Addrinfo.html#method-i-ipv6_mc_nodelocal-3F","()","<p>Returns true for IPv6 multicast node-local scope address. It returns false otherwise.\n"],["ipv6_mc_orglocal?","Addrinfo","Addrinfo.html#method-i-ipv6_mc_orglocal-3F","()","<p>Returns true for IPv6 multicast organization-local scope address. It returns false otherwise.\n"],["ipv6_mc_sitelocal?","Addrinfo","Addrinfo.html#method-i-ipv6_mc_sitelocal-3F","()","<p>Returns true for IPv6 multicast site-local scope address. It returns false otherwise.\n"],["ipv6_multicast?","Addrinfo","Addrinfo.html#method-i-ipv6_multicast-3F","()","<p>Returns true for IPv6 multicast address (ff00::/8). It returns false otherwise.\n"],["ipv6_pktinfo","Socket::AncillaryData","Socket/AncillaryData.html#method-c-ipv6_pktinfo","(p1, p2)","<p>Returns new ancillary data for IPV6_PKTINFO.\n<p>IPV6_PKTINFO is defined by RFC 3542.\n\n<pre class=\"ruby\"><span class=\"ruby-identifier\">addr</span> = <span class=\"ruby-constant\">Addrinfo</span>.<span class=\"ruby-identifier\">ip</span>(<span class=\"ruby-string\">&quot;::1&quot;</span>) <span class=\"ruby-operator\">...</span>\n</pre>\n"],["ipv6_pktinfo","Socket::AncillaryData","Socket/AncillaryData.html#method-i-ipv6_pktinfo","()","<p>Extracts addr and ifindex from IPV6_PKTINFO ancillary data.\n<p>IPV6_PKTINFO is defined by RFC 3542.\n\n<pre>addr = ...</pre>\n"],["ipv6_pktinfo_addr","Socket::AncillaryData","Socket/AncillaryData.html#method-i-ipv6_pktinfo_addr","()","<p>Extracts addr from IPV6_PKTINFO ancillary data.\n<p>IPV6_PKTINFO is defined by RFC 3542.\n\n<pre class=\"ruby\"><span class=\"ruby-identifier\">addr</span> = <span class=\"ruby-constant\">Addrinfo</span>.<span class=\"ruby-identifier\">ip</span>(<span class=\"ruby-string\">&quot;::1&quot;</span>) <span class=\"ruby-operator\">...</span>\n</pre>\n"],["ipv6_pktinfo_ifindex","Socket::AncillaryData","Socket/AncillaryData.html#method-i-ipv6_pktinfo_ifindex","()","<p>Extracts ifindex from IPV6_PKTINFO ancillary data.\n<p>IPV6_PKTINFO is defined by RFC 3542.\n\n<pre class=\"ruby\"><span class=\"ruby-identifier\">addr</span> = <span class=\"ruby-constant\">Addrinfo</span>.<span class=\"ruby-identifier\">ip</span>(<span class=\"ruby-string\">&quot;::1&quot;</span>) <span class=\"ruby-operator\">...</span>\n</pre>\n"],["ipv6_sitelocal?","Addrinfo","Addrinfo.html#method-i-ipv6_sitelocal-3F","()","<p>Returns true for IPv6 site local address (fec0::/10). It returns false otherwise.\n"],["ipv6_to_ipv4","Addrinfo","Addrinfo.html#method-i-ipv6_to_ipv4","()","<p>Returns IPv4 address of IPv4 mapped/compatible IPv6 address. It returns nil if <code>self</code> is not IPv4 mapped/compatible …\n"],["ipv6_unique_local?","Addrinfo","Addrinfo.html#method-i-ipv6_unique_local-3F","()","<p>Returns true for IPv6 unique local address (fc00::/7, RFC4193). It returns false otherwise.\n"],["ipv6_unspecified?","Addrinfo","Addrinfo.html#method-i-ipv6_unspecified-3F","()","<p>Returns true for IPv6 unspecified address (::). It returns false otherwise.\n"],["ipv6_v4compat?","Addrinfo","Addrinfo.html#method-i-ipv6_v4compat-3F","()","<p>Returns true for IPv4-compatible IPv6 address (::/80). It returns false otherwise.\n"],["ipv6_v4mapped?","Addrinfo","Addrinfo.html#method-i-ipv6_v4mapped-3F","()","<p>Returns true for IPv4-mapped IPv6 address (::ffff:0:0/80). It returns false otherwise.\n"],["ipv6only!","Socket","Socket.html#method-i-ipv6only-21","()","<p>enable the socket option IPV6_V6ONLY if IPV6_V6ONLY is available.\n"],["level","Socket::AncillaryData","Socket/AncillaryData.html#method-i-level","()","<p>returns the cmsg level as an integer.\n\n<pre class=\"ruby\"><span class=\"ruby-identifier\">p</span> <span class=\"ruby-constant\">Socket</span><span class=\"ruby-operator\">::</span><span class=\"ruby-constant\">AncillaryData</span>.<span class=\"ruby-identifier\">new</span>(<span class=\"ruby-value\">:INET6</span>, <span class=\"ruby-value\">:IPV6</span>, <span class=\"ruby-value\">:PKTINFO</span>, <span class=\"ruby-string\">&quot;&quot;</span>).<span class=\"ruby-identifier\">level</span>\n<span class=\"ruby-comment\">#=&gt; ...</span>\n</pre>\n"],["level","Socket::Option","Socket/Option.html#method-i-level","()","<p>returns the socket level as an integer.\n\n<pre class=\"ruby\"><span class=\"ruby-identifier\">p</span> <span class=\"ruby-constant\">Socket</span><span class=\"ruby-operator\">::</span><span class=\"ruby-constant\">Option</span>.<span class=\"ruby-identifier\">new</span>(<span class=\"ruby-value\">:INET6</span>, <span class=\"ruby-value\">:IPV6</span>, <span class=\"ruby-value\">:RECVPKTINFO</span>, [<span class=\"ruby-value\">1</span>].<span class=\"ruby-identifier\">pack</span>(<span class=\"ruby-string\">&quot;i!&quot;</span>)).<span class=\"ruby-identifier\">level</span> <span class=\"ruby-operator\">...</span>\n</pre>\n"],["linger","Socket::Option","Socket/Option.html#method-c-linger","(p1, p2)","<p>Creates a new Socket::Option object for SOL_SOCKET/SO_LINGER.\n<p><em>onoff</em> should be an integer or a boolean. …\n"],["linger","Socket::Option","Socket/Option.html#method-i-linger","()","<p>Returns the linger data in <em>sockopt</em> as a pair of boolean and integer.\n\n<pre>sockopt = Socket::Option.linger(true, ...</pre>\n"],["listen","Addrinfo","Addrinfo.html#method-i-listen","(backlog=Socket::SOMAXCONN)","<p>creates a listening socket bound to self.\n"],["listen","Socket","Socket.html#method-i-listen","(p1)","<p>Listens for connections, using the specified <code>int</code> as the backlog. A call to <em>listen</em> only applies if the …\n"],["listen","TCPServer","TCPServer.html#method-i-listen","(p1)","<p>Listens for connections, using the specified <code>int</code> as the backlog. A call to <em>listen</em> only applies if the …\n"],["listen","UNIXServer","UNIXServer.html#method-i-listen","(p1)","<p>Listens for connections, using the specified <code>int</code> as the backlog. A call to <em>listen</em> only applies if the …\n"],["local_address","BasicSocket","BasicSocket.html#method-i-local_address","()","<p>Returns an Addrinfo object for local address obtained by getsockname.\n<p>Note that addrinfo.protocol is filled …\n"],["name","Socket::Ifaddr","Socket/Ifaddr.html#method-i-name","()","<p>Returns the interface name of <em>ifaddr</em>.\n"],["netmask","Socket::Ifaddr","Socket/Ifaddr.html#method-i-netmask","()","<p>Returns the netmask address of <em>ifaddr</em>. nil is returned if netmask is not available in <em>ifaddr</em>.\n"],["new","Addrinfo","Addrinfo.html#method-c-new","(p1, p2 = v2, p3 = v3, p4 = v4)","<p>returns a new instance of Addrinfo. The instance contains sockaddr, family, socktype, protocol. sockaddr …\n"],["new","SOCKSSocket","SOCKSSocket.html#method-c-new","(p1, p2)","<p>Opens a SOCKS connection to <code>host</code> via the SOCKS server.\n<p>The SOCKS server configuration varies by implementation …\n"],["new","Socket","Socket.html#method-c-new","(p1, p2, p3 = v3)","<p>Creates a new socket object.\n<p><em>domain</em> should be a communications domain such as: :INET, :INET6, :UNIX, etc. …\n"],["new","Socket::AncillaryData","Socket/AncillaryData.html#method-c-new","(p1, p2, p3, p4)","<p><em>family</em> should be an integer, a string or a symbol.\n<p>Socket::AF_INET, “AF_INET”, “INET”, …\n"],["new","Socket::HostnameResolutionResult","Socket/HostnameResolutionResult.html#method-c-new","(size)",""],["new","Socket::HostnameResolutionStore","Socket/HostnameResolutionStore.html#method-c-new","(family_names)",""],["new","Socket::Option","Socket/Option.html#method-c-new","(p1, p2, p3, p4)","<p>Returns a new Socket::Option object.\n\n<pre class=\"ruby\"><span class=\"ruby-identifier\">sockopt</span> = <span class=\"ruby-constant\">Socket</span><span class=\"ruby-operator\">::</span><span class=\"ruby-constant\">Option</span>.<span class=\"ruby-identifier\">new</span>(<span class=\"ruby-value\">:INET</span>, <span class=\"ruby-value\">:SOCKET</span>, <span class=\"ruby-value\">:KEEPALIVE</span>, [<span class=\"ruby-value\">1</span>].<span class=\"ruby-identifier\">pack</span>(<span class=\"ruby-string\">&quot;i&quot;</span>)) <span class=\"ruby-operator\">...</span>\n</pre>\n"],["new","Socket::UDPSource","Socket/UDPSource.html#method-c-new","(remote_address, local_address, &reply_proc)","<p><code>remote_address</code> is an Addrinfo object.\n<p><code>local_address</code> is an Addrinfo object.\n<p><code>reply_proc</code> is a Proc used to …\n"],["new","TCPServer","TCPServer.html#method-c-new","(p1 = v1, p2)","<p>Creates a new server socket bound to <em>port</em>.\n<p>If <em>hostname</em> is given, the socket is bound to it.\n\n<pre>serv = TCPServer.new(&quot;127.0.0.1&quot;, ...</pre>\n"],["new","TCPSocket","TCPSocket.html#method-c-new","(p1, p2, p3 = v3, p4 = v4, p5 = {})","<p>Opens a TCP connection to <code>remote_host</code> on <code>remote_port</code>.  If <code>local_host</code> and <code>local_port</code> are specified, then …\n"],["new","UDPSocket","UDPSocket.html#method-c-new","(p1 = v1)","<p>Creates a new UDPSocket object.\n<p><em>address_family</em> should be an integer, a string or a symbol: Socket::AF_INET …\n"],["new","UNIXServer","UNIXServer.html#method-c-new","(p1)","<p>Creates a new UNIX server socket bound to <em>path</em>.\n\n<pre class=\"ruby\"><span class=\"ruby-identifier\">require</span> <span class=\"ruby-string\">&#39;socket&#39;</span>\n\n<span class=\"ruby-identifier\">serv</span> = <span class=\"ruby-constant\">UNIXServer</span>.<span class=\"ruby-identifier\">new</span>(<span class=\"ruby-string\">&quot;/tmp/sock&quot;</span>)\n<span class=\"ruby-identifier\">s</span> <span class=\"ruby-operator\">...</span>\n</pre>\n"],["new","UNIXSocket","UNIXSocket.html#method-c-new","(p1)","<p>Creates a new UNIX client socket connected to <em>path</em>.\n\n<pre class=\"ruby\"><span class=\"ruby-identifier\">require</span> <span class=\"ruby-string\">&#39;socket&#39;</span>\n\n<span class=\"ruby-identifier\">s</span> = <span class=\"ruby-constant\">UNIXSocket</span>.<span class=\"ruby-identifier\">new</span>(<span class=\"ruby-string\">&quot;/tmp/sock&quot;</span>) <span class=\"ruby-operator\">...</span>\n</pre>\n"],["notifier","Socket::HostnameResolutionResult","Socket/HostnameResolutionResult.html#method-i-notifier","()",""],["optname","Socket::Option","Socket/Option.html#method-i-optname","()","<p>returns the socket option name as an integer.\n\n<pre class=\"ruby\"><span class=\"ruby-identifier\">p</span> <span class=\"ruby-constant\">Socket</span><span class=\"ruby-operator\">::</span><span class=\"ruby-constant\">Option</span>.<span class=\"ruby-identifier\">new</span>(<span class=\"ruby-value\">:INET6</span>, <span class=\"ruby-value\">:IPV6</span>, <span class=\"ruby-value\">:RECVPKTINFO</span>, [<span class=\"ruby-value\">1</span>].<span class=\"ruby-identifier\">pack</span>(<span class=\"ruby-string\">&quot;i!&quot;</span>)).<span class=\"ruby-identifier\">optname</span> <span class=\"ruby-operator\">...</span>\n</pre>\n"],["pack_sockaddr_in","Socket","Socket.html#method-c-pack_sockaddr_in","(p1, p2)","<p>Packs <em>port</em> and <em>host</em> as an AF_INET/AF_INET6 sockaddr string.\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">Socket</span>.<span class=\"ruby-identifier\">sockaddr_in</span>(<span class=\"ruby-value\">80</span>, <span class=\"ruby-string\">&quot;127.0.0.1&quot;</span>)\n<span class=\"ruby-comment\">#=&gt; &quot;\\x02\\x00\\x00P\\x7F\\x00\\x00\\x01\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00&quot; ...</span>\n</pre>\n"],["pack_sockaddr_un","Socket","Socket.html#method-c-pack_sockaddr_un","(p1)","<p>Packs <em>path</em> as an AF_UNIX sockaddr string.\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">Socket</span>.<span class=\"ruby-identifier\">sockaddr_un</span>(<span class=\"ruby-string\">&quot;/tmp/sock&quot;</span>) <span class=\"ruby-comment\">#=&gt; &quot;\\x01\\x00/tmp/sock\\x00\\x00...&quot;</span>\n</pre>\n"],["pair","Socket","Socket.html#method-c-pair","(p1, p2, p3 = v3)","<p>Creates a pair of sockets connected each other.\n<p><em>domain</em> should be a communications domain such as: :INET, …\n"],["pair","UNIXSocket","UNIXSocket.html#method-c-pair","(p1 = v1, p2 = v2)","<p>Creates a pair of sockets connected to each other.\n<p><em>type</em> should be a socket type such as: :STREAM, :DGRAM, …\n"],["path","UNIXSocket","UNIXSocket.html#method-i-path","()","<p>Returns the path of the local address of unixsocket.\n\n<pre class=\"ruby\"><span class=\"ruby-identifier\">s</span> = <span class=\"ruby-constant\">UNIXServer</span>.<span class=\"ruby-identifier\">new</span>(<span class=\"ruby-string\">&quot;/tmp/sock&quot;</span>)\n<span class=\"ruby-identifier\">p</span> <span class=\"ruby-identifier\">s</span>.<span class=\"ruby-identifier\">path</span> <span class=\"ruby-comment\">#=&gt; &quot;/tmp/sock&quot;</span>\n</pre>\n"],["peeraddr","IPSocket","IPSocket.html#method-i-peeraddr","(*args)","<p>Returns the remote address as an array which contains address_family, port, hostname and numeric_address. …\n"],["peeraddr","UNIXSocket","UNIXSocket.html#method-i-peeraddr","()","<p>Returns the remote address as an array which contains address_family and unix_path.\n<p>Example\n\n<pre class=\"ruby\"><span class=\"ruby-identifier\">serv</span> = <span class=\"ruby-constant\">UNIXServer</span>.<span class=\"ruby-identifier\">new</span>(<span class=\"ruby-string\">&quot;/tmp/sock&quot;</span>) <span class=\"ruby-operator\">...</span>\n</pre>\n"],["pfamily","Addrinfo","Addrinfo.html#method-i-pfamily","()","<p>returns the protocol family as an integer.\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">Addrinfo</span>.<span class=\"ruby-identifier\">tcp</span>(<span class=\"ruby-string\">&quot;localhost&quot;</span>, <span class=\"ruby-value\">80</span>).<span class=\"ruby-identifier\">pfamily</span> <span class=\"ruby-operator\">==</span> <span class=\"ruby-constant\">Socket</span><span class=\"ruby-operator\">::</span><span class=\"ruby-constant\">PF_INET</span> <span class=\"ruby-comment\">#=&gt; ...</span>\n</pre>\n"],["protocol","Addrinfo","Addrinfo.html#method-i-protocol","()","<p>returns the socket type as an integer.\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">Addrinfo</span>.<span class=\"ruby-identifier\">tcp</span>(<span class=\"ruby-string\">&quot;localhost&quot;</span>, <span class=\"ruby-value\">80</span>).<span class=\"ruby-identifier\">protocol</span> <span class=\"ruby-operator\">==</span> <span class=\"ruby-constant\">Socket</span><span class=\"ruby-operator\">::</span><span class=\"ruby-constant\">IPPROTO_TCP</span> <span class=\"ruby-comment\">#=&gt; ...</span>\n</pre>\n"],["recv","BasicSocket","BasicSocket.html#method-i-recv","(*args)","<p>Receives a message.\n<p><em>maxlen</em> is the maximum number of bytes to receive.\n<p><em>flags</em> should be a bitwise OR of  …\n"],["recv_io","UNIXSocket","UNIXSocket.html#method-i-recv_io","(p1 = v1, p2 = v2)","<p>Example\n\n<pre>UNIXServer.open(&quot;/tmp/sock&quot;) {|serv|\n  UNIXSocket.open(&quot;/tmp/sock&quot;) {|c|\n    s = serv.accept\n ...</pre>\n"],["recv_nonblock","BasicSocket","BasicSocket.html#method-i-recv_nonblock","(len, flag = 0, str = nil, exception: true)","<p>Receives up to <em>maxlen</em> bytes from <code>socket</code> using recvfrom(2) after O_NONBLOCK is set for the underlying …\n"],["recvfrom","IPSocket","IPSocket.html#method-i-recvfrom","(*args)","<p>Receives a message and return the message as a string and an address which the message come from.\n<p><em>maxlen</em> …\n"],["recvfrom","Socket","Socket.html#method-i-recvfrom","(*args)","<p>Receives up to <em>maxlen</em> bytes from <code>socket</code>. <em>flags</em> is zero or more of the <code>MSG_</code> options. The first element …\n"],["recvfrom","UNIXSocket","UNIXSocket.html#method-i-recvfrom","(*args)","<p>Receives a message via <em>unixsocket</em>.\n<p><em>maxlen</em> is the maximum number of bytes to receive.\n<p><em>flags</em> should be a …\n"],["recvfrom_nonblock","Socket","Socket.html#method-i-recvfrom_nonblock","(len, flag = 0, str = nil, exception: true)","<p>Receives up to <em>maxlen</em> bytes from <code>socket</code> using recvfrom(2) after O_NONBLOCK is set for the underlying …\n"],["recvfrom_nonblock","UDPSocket","UDPSocket.html#method-i-recvfrom_nonblock","(len, flag = 0, outbuf = nil, exception: true)","<p>Receives up to <em>maxlen</em> bytes from <code>udpsocket</code> using recvfrom(2) after O_NONBLOCK is set for the underlying …\n"],["recvmsg","BasicSocket","BasicSocket.html#method-i-recvmsg","(dlen = nil, flags = 0, clen = nil, scm_rights: false)","<p>recvmsg receives a message using recvmsg(2) system call in blocking manner.\n<p><em>maxmesglen</em> is the maximum …\n"],["recvmsg_nonblock","BasicSocket","BasicSocket.html#method-i-recvmsg_nonblock","(dlen = nil, flags = 0, clen = nil, scm_rights: false, exception: true)","<p>recvmsg receives a message using recvmsg(2) system call in non-blocking manner.\n<p>It is similar to BasicSocket#recvmsg …\n"],["remote_address","BasicSocket","BasicSocket.html#method-i-remote_address","()","<p>Returns an Addrinfo object for remote address obtained by getpeername.\n<p>Note that addrinfo.protocol is …\n"],["reply","Socket::UDPSource","Socket/UDPSource.html#method-i-reply","(msg)","<p>Sends the String <code>msg</code> to the source\n"],["resolve_hostname","Socket","Socket.html#method-c-resolve_hostname","(family, host, port, hostname_resolution_result)",""],["resolved?","Socket::HostnameResolutionStore","Socket/HostnameResolutionStore.html#method-i-resolved-3F","(family)",""],["resolved_all_families?","Socket::HostnameResolutionStore","Socket/HostnameResolutionStore.html#method-i-resolved_all_families-3F","()",""],["resolved_successfully?","Socket::HostnameResolutionStore","Socket/HostnameResolutionStore.html#method-i-resolved_successfully-3F","(family)",""],["reverse_each_name","Object","Object.html#method-i-reverse_each_name","(pat)",""],["reverse_each_name_with_prefix_optional","Object","Object.html#method-i-reverse_each_name_with_prefix_optional","(pat, prefix_pat)",""],["second_to_timeout","Socket","Socket.html#method-c-second_to_timeout","(started_at, ends_at)",""],["send","BasicSocket","BasicSocket.html#method-i-send","(p1, p2, p3 = v3)","<p>send <em>mesg</em> via <em>basicsocket</em>.\n<p><em>mesg</em> should be a string.\n<p><em>flags</em> should be a bitwise OR of Socket::MSG_* constants. …\n"],["send","UDPSocket","UDPSocket.html#method-i-send","(p1, p2, p3, p4)","<p>Sends <em>mesg</em> via <em>udpsocket</em>.\n<p><em>flags</em> should be a bitwise OR of Socket::MSG_* constants.\n\n<pre>u1 = UDPSocket.new\nu1.bind(&quot;127.0.0.1&quot;, ...</pre>\n"],["send_io","UNIXSocket","UNIXSocket.html#method-i-send_io","(p1)","<p>Sends <em>io</em> as file descriptor passing.\n\n<pre>s1, s2 = UNIXSocket.pair\n\ns1.send_io STDOUT\nstdout = s2.recv_io\n ...</pre>\n"],["sendmsg","BasicSocket","BasicSocket.html#method-i-sendmsg","(mesg, flags = 0, dest_sockaddr = nil, *controls)","<p>sendmsg sends a message using sendmsg(2) system call in blocking manner.\n<p><em>mesg</em> is a string to send.\n<p><em>flags</em> …\n"],["sendmsg_nonblock","BasicSocket","BasicSocket.html#method-i-sendmsg_nonblock","(mesg, flags = 0, dest_sockaddr = nil, *controls, exception: true)","<p>sendmsg_nonblock sends a message using sendmsg(2) system call in non-blocking manner.\n<p>It is similar to …\n"],["setsockopt","BasicSocket","BasicSocket.html#method-i-setsockopt","(p1, p2, p3)","<p>Sets a socket option. These are protocol and system specific, see your local system documentation for …\n"],["shutdown","BasicSocket","BasicSocket.html#method-i-shutdown","(p1 = v1)","<p>Calls shutdown(2) system call.\n<p>s.shutdown(Socket::SHUT_RD) disallows further read.\n<p>s.shutdown(Socket::SHUT_WR …\n"],["sockaddr_in","Socket","Socket.html#method-c-sockaddr_in","(p1, p2)","<p>Packs <em>port</em> and <em>host</em> as an AF_INET/AF_INET6 sockaddr string.\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">Socket</span>.<span class=\"ruby-identifier\">sockaddr_in</span>(<span class=\"ruby-value\">80</span>, <span class=\"ruby-string\">&quot;127.0.0.1&quot;</span>)\n<span class=\"ruby-comment\">#=&gt; &quot;\\x02\\x00\\x00P\\x7F\\x00\\x00\\x01\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00&quot; ...</span>\n</pre>\n"],["sockaddr_un","Socket","Socket.html#method-c-sockaddr_un","(p1)","<p>Packs <em>path</em> as an AF_UNIX sockaddr string.\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">Socket</span>.<span class=\"ruby-identifier\">sockaddr_un</span>(<span class=\"ruby-string\">&quot;/tmp/sock&quot;</span>) <span class=\"ruby-comment\">#=&gt; &quot;\\x01\\x00/tmp/sock\\x00\\x00...&quot;</span>\n</pre>\n"],["socketpair","Socket","Socket.html#method-c-socketpair","(p1, p2, p3 = v3)","<p>Creates a pair of sockets connected each other.\n<p><em>domain</em> should be a communications domain such as: :INET, …\n"],["socketpair","UNIXSocket","UNIXSocket.html#method-c-socketpair","(p1 = v1, p2 = v2)","<p>Creates a pair of sockets connected to each other.\n<p><em>type</em> should be a socket type such as: :STREAM, :DGRAM, …\n"],["socktype","Addrinfo","Addrinfo.html#method-i-socktype","()","<p>returns the socket type as an integer.\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">Addrinfo</span>.<span class=\"ruby-identifier\">tcp</span>(<span class=\"ruby-string\">&quot;localhost&quot;</span>, <span class=\"ruby-value\">80</span>).<span class=\"ruby-identifier\">socktype</span> <span class=\"ruby-operator\">==</span> <span class=\"ruby-constant\">Socket</span><span class=\"ruby-operator\">::</span><span class=\"ruby-constant\">SOCK_STREAM</span> <span class=\"ruby-comment\">#=&gt; ...</span>\n</pre>\n"],["sysaccept","Socket","Socket.html#method-i-sysaccept","()","<p>Accepts an incoming connection returning an array containing the (integer) file descriptor for the incoming …\n"],["sysaccept","TCPServer","TCPServer.html#method-i-sysaccept","()","<p>Returns a file descriptor of a accepted connection.\n\n<pre>TCPServer.open(&quot;127.0.0.1&quot;, 28561) {|serv|\n  fd = ...</pre>\n"],["sysaccept","UNIXServer","UNIXServer.html#method-i-sysaccept","()","<p>Accepts a new connection. It returns the new file descriptor which is an integer.\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">UNIXServer</span>.<span class=\"ruby-identifier\">open</span>(<span class=\"ruby-string\">&quot;/tmp/sock&quot;</span>) <span class=\"ruby-operator\">...</span>\n</pre>\n"],["tcp","Addrinfo","Addrinfo.html#method-c-tcp","(p1, p2)","<p>returns an addrinfo object for TCP address.\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">Addrinfo</span>.<span class=\"ruby-identifier\">tcp</span>(<span class=\"ruby-string\">&quot;localhost&quot;</span>, <span class=\"ruby-string\">&quot;smtp&quot;</span>) <span class=\"ruby-comment\">#=&gt; #&lt;Addrinfo: 127.0.0.1:25 ...</span>\n</pre>\n"],["tcp","Socket","Socket.html#method-c-tcp","(host, port, local_host = nil, local_port = nil, connect_timeout: nil, resolv_timeout: nil, fast_fallback: tcp_fast_fallback, &)","<p>creates a new socket object connected to host:port using TCP/IP.\n<p>Starting from Ruby 3.4, this method operates …\n"],["tcp_fast_fallback","Socket","Socket.html#method-c-tcp_fast_fallback","()","<p>Returns whether Happy Eyeballs Version 2 (RFC 8305), which is provided starting from Ruby 3.4 when using …\n"],["tcp_fast_fallback=","Socket","Socket.html#method-c-tcp_fast_fallback-3D","(p1)","<p>Enable or disable Happy Eyeballs Version 2 (RFC 8305) globally, which is provided starting from Ruby …\n"],["tcp_server_loop","Socket","Socket.html#method-c-tcp_server_loop","(host=nil, port)","<p>creates a TCP/IP server on <em>port</em> and calls the block for each connection accepted. The block is called …\n"],["tcp_server_sockets","Socket","Socket.html#method-c-tcp_server_sockets","(host=nil, port)","<p>creates TCP/IP server sockets for <em>host</em> and <em>port</em>. <em>host</em> is optional.\n<p>If no block given, it returns an array …\n"],["tcp_with_fast_fallback","Socket","Socket.html#method-c-tcp_with_fast_fallback","(host, port, local_host = nil, local_port = nil, connect_timeout: nil, resolv_timeout: nil)",""],["tcp_without_fast_fallback","Socket","Socket.html#method-c-tcp_without_fast_fallback","(host, port, local_host, local_port, connect_timeout:, resolv_timeout:)",""],["timestamp","Socket::AncillaryData","Socket/AncillaryData.html#method-i-timestamp","()","<p>returns the timestamp as a time object.\n<p><em>ancillarydata</em> should be one of following type:\n<p>SOL_SOCKET/SCM_TIMESTAMP …\n"],["to_s","Addrinfo","Addrinfo.html#method-i-to_s","()","<p>returns the socket address as packed struct sockaddr string.\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">Addrinfo</span>.<span class=\"ruby-identifier\">tcp</span>(<span class=\"ruby-string\">&quot;localhost&quot;</span>, <span class=\"ruby-value\">80</span>).<span class=\"ruby-identifier\">to_sockaddr</span> <span class=\"ruby-operator\">...</span>\n</pre>\n"],["to_s","Socket::Option","Socket/Option.html#method-i-to_s","()","<p>returns the socket option data as a string.\n\n<pre class=\"ruby\"><span class=\"ruby-identifier\">p</span> <span class=\"ruby-constant\">Socket</span><span class=\"ruby-operator\">::</span><span class=\"ruby-constant\">Option</span>.<span class=\"ruby-identifier\">new</span>(<span class=\"ruby-value\">:INET6</span>, <span class=\"ruby-value\">:IPV6</span>, <span class=\"ruby-value\">:RECVPKTINFO</span>, [<span class=\"ruby-value\">1</span>].<span class=\"ruby-identifier\">pack</span>(<span class=\"ruby-string\">&quot;i!&quot;</span>)).<span class=\"ruby-identifier\">data</span> <span class=\"ruby-operator\">...</span>\n</pre>\n"],["to_sockaddr","Addrinfo","Addrinfo.html#method-i-to_sockaddr","()","<p>returns the socket address as packed struct sockaddr string.\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">Addrinfo</span>.<span class=\"ruby-identifier\">tcp</span>(<span class=\"ruby-string\">&quot;localhost&quot;</span>, <span class=\"ruby-value\">80</span>).<span class=\"ruby-identifier\">to_sockaddr</span> <span class=\"ruby-operator\">...</span>\n</pre>\n"],["type","Socket::AncillaryData","Socket/AncillaryData.html#method-i-type","()","<p>returns the cmsg type as an integer.\n\n<pre class=\"ruby\"><span class=\"ruby-identifier\">p</span> <span class=\"ruby-constant\">Socket</span><span class=\"ruby-operator\">::</span><span class=\"ruby-constant\">AncillaryData</span>.<span class=\"ruby-identifier\">new</span>(<span class=\"ruby-value\">:INET6</span>, <span class=\"ruby-value\">:IPV6</span>, <span class=\"ruby-value\">:PKTINFO</span>, <span class=\"ruby-string\">&quot;&quot;</span>).<span class=\"ruby-identifier\">type</span>\n<span class=\"ruby-comment\">#=&gt; ...</span>\n</pre>\n"],["udp","Addrinfo","Addrinfo.html#method-c-udp","(p1, p2)","<p>returns an addrinfo object for UDP address.\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">Addrinfo</span>.<span class=\"ruby-identifier\">udp</span>(<span class=\"ruby-string\">&quot;localhost&quot;</span>, <span class=\"ruby-string\">&quot;daytime&quot;</span>) <span class=\"ruby-comment\">#=&gt; #&lt;Addrinfo: 127.0.0.1:13 ...</span>\n</pre>\n"],["udp_server_loop","Socket","Socket.html#method-c-udp_server_loop","(host=nil, port)","<p>creates a UDP/IP server on <em>port</em> and calls the block for each message arrived. The block is called with …\n"],["udp_server_loop_on","Socket","Socket.html#method-c-udp_server_loop_on","(sockets)","<p>Run UDP/IP server loop on the given sockets.\n<p>The return value of Socket.udp_server_sockets is appropriate …\n"],["udp_server_recv","Socket","Socket.html#method-c-udp_server_recv","(sockets)","<p>Receive UDP/IP packets from the given <em>sockets</em>. For each packet received, the block is called.\n<p>The block …\n"],["udp_server_sockets","Socket","Socket.html#method-c-udp_server_sockets","(host=nil, port)","<p>Creates UDP/IP sockets for a UDP server.\n<p>If no block given, it returns an array of sockets.\n<p>If a block …\n"],["unix","Addrinfo","Addrinfo.html#method-c-unix","(p1, p2 = v2)","<p>returns an addrinfo object for UNIX socket address.\n<p><em>socktype</em> specifies the socket type. If it is omitted, …\n"],["unix","Socket","Socket.html#method-c-unix","(path)","<p>creates a new socket connected to path using UNIX socket socket.\n<p>If a block is given, the block is called …\n"],["unix?","Addrinfo","Addrinfo.html#method-i-unix-3F","()","<p>returns true if addrinfo is UNIX address. returns false otherwise.\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">Addrinfo</span>.<span class=\"ruby-identifier\">tcp</span>(<span class=\"ruby-string\">&quot;127.0.0.1&quot;</span>, <span class=\"ruby-value\">80</span>).<span class=\"ruby-identifier\">unix?</span> <span class=\"ruby-operator\">...</span>\n</pre>\n"],["unix_path","Addrinfo","Addrinfo.html#method-i-unix_path","()","<p>Returns the socket path as a string.\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">Addrinfo</span>.<span class=\"ruby-identifier\">unix</span>(<span class=\"ruby-string\">&quot;/tmp/sock&quot;</span>).<span class=\"ruby-identifier\">unix_path</span>       <span class=\"ruby-comment\">#=&gt; &quot;/tmp/sock&quot;</span>\n</pre>\n"],["unix_rights","Socket::AncillaryData","Socket/AncillaryData.html#method-c-unix_rights","(*args)","<p>Creates a new Socket::AncillaryData object which contains file descriptors as data.\n\n<pre class=\"ruby\"><span class=\"ruby-identifier\">p</span> <span class=\"ruby-constant\">Socket</span><span class=\"ruby-operator\">::</span><span class=\"ruby-constant\">AncillaryData</span>.<span class=\"ruby-identifier\">unix_rights</span>(<span class=\"ruby-constant\">STDERR</span>) <span class=\"ruby-operator\">...</span>\n</pre>\n"],["unix_rights","Socket::AncillaryData","Socket/AncillaryData.html#method-i-unix_rights","()","<p>returns the array of IO objects for SCM_RIGHTS control message in UNIX domain socket.\n<p>The class of the …\n"],["unix_server_loop","Socket","Socket.html#method-c-unix_server_loop","(path)","<p>creates a UNIX socket server on <em>path</em>. It calls the block for each socket accepted.\n<p>If <em>host</em> is specified, …\n"],["unix_server_socket","Socket","Socket.html#method-c-unix_server_socket","(path)","<p>creates a UNIX server socket on <em>path</em>\n<p>If no block given, it returns a listening socket.\n<p>If a block is given, …\n"],["unix_socket_abstract_name?","Socket","Socket.html#method-c-unix_socket_abstract_name-3F","(path)",""],["unpack","Socket::Option","Socket/Option.html#method-i-unpack","(p1)","<p>Calls String#unpack on sockopt.data.\n\n<pre class=\"ruby\"><span class=\"ruby-identifier\">sockopt</span> = <span class=\"ruby-constant\">Socket</span><span class=\"ruby-operator\">::</span><span class=\"ruby-constant\">Option</span>.<span class=\"ruby-identifier\">new</span>(<span class=\"ruby-value\">:INET</span>, <span class=\"ruby-value\">:SOCKET</span>, <span class=\"ruby-value\">:KEEPALIVE</span>, [<span class=\"ruby-value\">1</span>].<span class=\"ruby-identifier\">pack</span>(<span class=\"ruby-string\">&quot;i&quot;</span>)) <span class=\"ruby-operator\">...</span>\n</pre>\n"],["unpack_sockaddr_in","Socket","Socket.html#method-c-unpack_sockaddr_in","(p1)","<p>Unpacks <em>sockaddr</em> into port and ip_address.\n<p><em>sockaddr</em> should be a string or an addrinfo for AF_INET/AF_INET6. …\n"],["unpack_sockaddr_un","Socket","Socket.html#method-c-unpack_sockaddr_un","(p1)","<p>Unpacks <em>sockaddr</em> into path.\n<p><em>sockaddr</em> should be a string or an addrinfo for AF_UNIX.\n\n<pre class=\"ruby\"><span class=\"ruby-identifier\">sockaddr</span> = <span class=\"ruby-constant\">Socket</span>.<span class=\"ruby-identifier\">sockaddr_un</span>(<span class=\"ruby-string\">&quot;/tmp/sock&quot;</span>) <span class=\"ruby-operator\">...</span>\n</pre>\n"],["vhid","Socket::Ifaddr","Socket/Ifaddr.html#method-i-vhid","()","<p>Returns the vhid address of <em>ifaddr</em>. nil is returned if there is no vhid.\n"]]}}